<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicantInitialInterviewReschedulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('applicant_init_int_resched', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('initial_interview_schedule')->unsigned();
            $table->bigInteger('status')->comment('1 - Pending, 2 - Approved, 3 - Rejected');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('initial_interview_schedule')->references('id')->on('applicant_initial_interviews')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('applicant_init_int_resched');
    }
}
