<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPhsIdTableApplication extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('applications', function (Blueprint $table) {
            $table->unsignedBigInteger('phs_id')->after('position_id')->default('1');
            $table->foreign('phs_id')->references('id')->on(env('HRJP_DB_DATABASE').'.position_has_salaries');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('applications', function (Blueprint $table) {
            $table->dropColumn('phs_id');
        });
    }
}
