<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePositionHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('position_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('position_id');
            $table->date('appointment_date');
            $table->date('date_of_effectivity');
            $table->integer('status')->comment('1 = promoted, 2 = demoted')->nullable();
            $table->integer('position_status')->comment('1 = current position, 2 = previous position')->default(1);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('position_id')->references('id')->on(env('HRJP_DB_DATABASE').'.positions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->dropIfExists('position_histories');
    }
}
