<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicantExamInterviewReschedulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('applicant_exam_interview_reschedules', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('interview_schedule')->unsigned();
            $table->bigInteger('status')->comment('1 - Pending, 2 - Approved, 3 - Rejected');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('interview_schedule')->references('id')->on('applicant_exam_interviews')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('applicant_exam_interview_reschedules');
    }
}
