<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicantExtraFieldHasMoreInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('applicant_extra_field_has_more_infos', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('applicant_extra_field')->unsigned();
            $table->string('field_name');
            $table->string('field_value');
            $table->string('field_type')->comment('text, select, checkbox, radio');
            $table->integer('field_status')->comment('1 - enabled, 2 - disabled');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('applicant_extra_field', 'extra_field_relation')->references('id')->on('applicant_extra_fields')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('applicant_extra_field_has_more_infos');
    }
}
