<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicantExamReschedulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('applicant_exam_reschedules', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('exam_schedule')->unsigned();
            $table->bigInteger('status')->comment('1 - Pending, 2 - Approved, 3 - Rejected');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('exam_schedule')->references('id')->on('applicant_exam_schedules')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('applicant_exam_reschedules');
    }
}
