<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePositionHasSalariesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('position_has_salaries', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('position_id')->unsigned();
            $table->bigInteger('hiring_manager')->unsigned();
            $table->longtext('description');
            $table->longtext('salary');
            $table->bigInteger('slots');
            $table->bigInteger('post_status')->comment("1 = posted , 2 = not posted, 3 = on hold");
            $table->dateTime('post_due');
            $table->bigInteger('employee_type');
            $table->bigInteger('show_salary')->comment("1 = show , 2 = hide");;
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('position_id')
                ->references('id')
                ->on('positions')
                ->onDelete('cascade');

            $table->foreign('hiring_manager')
                ->references('id')
                ->on(env('DB_DATABASE').'.users')
                ->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('position_has_salaries');
    }

    
}
