<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('applications', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('applicant_id')->unsigned();
            $table->bigInteger('status')->comment("1 = active, 2 = inactive, 3 = deactivated, 4 = completed");
            $table->bigInteger('position_id')->unsigned();
            $table->bigInteger('step');
            $table->bigInteger('created_by'); 
            $table->bigInteger('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('applicant_id')
                ->references('id')
                ->on('applicant_accounts')
                ->onDelete('cascade');

            $table->foreign('position_id')
            ->references('id')
            ->on('positions')
            ->onDelete('cascade');
        });
    }


    /*
        $table->timestamp('created_at');
        $table->timestamp('updated_at');

    */
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('applications');
    }
}
