<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicantAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('applicant_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('email')->unique();
            $table->longText('fname');
            $table->longText('mname')->nullable();
            $table->longText('lname');
            $table->timestamp('email_verified_at')->nullable();
            $table->longText('password');
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });

        
    }

    /*
        $table->timestamps('created_at');
        $table->timestamps('updated_at');
    */

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->dropIfExists('applicant_accounts');
    }
}
