<?php

namespace Suiterus\Hrjp\Controllers;

use Suiterus\Hrjp\Models\Position_history;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PositionHistoryController extends Controller
{
    
    // ** fetch all 
    public function fetch_position_history(Request $req){

        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');

        $records = Position_history::with(['user' => function($query){

            $query->select('id', 'name')->without('permissions', 'roles', 'storage', 'supervisor','employeeMetaInfo');

        }])->whereHas('user')->whereHas('position')->where('user_id', $req->user_id)->orderBy('date_of_effectivity', 'desc')->paginate($paginate);

        return response()->json([
            'message'   =>  "Fetch successfully",
            'data'   =>  $records
        ]);

    }

    public function fetch_promoted_employees() {
        $promoted = 1;
        return Position_history::where('status', $promoted)->get();   
    }

    public function fetch_promoted_employees_dashboard()
    {
        $promoted = 1;
        return Position_history::select(
            'user_id',
            'item_code_id',
            'position_id',
            'appointment_date',
            'date_of_effectivity',
            'status'
        )
            ->where('status', $promoted)
            ->without(
                'user',
                'position',
                'pdsPerPosition',
                'itemCode'
            )->get();
    }
}
