<?php

namespace Suiterus\Hrjp\Controllers;

use Exception;
use Carbon\Carbon;
use App\Models\User;
use App\Enums\Status;
use Illuminate\Http\Request;
use App\Enums\ItemCodeStatus;
use App\Enums\CorporationList;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use Suiterus\Hrjp\Models\ItemCode;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Hrjp\Models\Position as P;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Hrjp\Models\Position_has_salary as PHS;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Hrjp\Models\JobPostExpenses;

class JobPostExpensesController extends Controller
{
    use HasCustomLogs;
    public function fetch(Request $request)
    {
        return JobPostExpenses::where('phs_id', $request->phs_id)->get();
    }

    public function create(Request $request)
    {
        $validate = Validator::make($request->all(), [

        ]);

        if ($validate->fails()) {
            return response()->json([
                'errors' => $validate->errors()
            ], 400);
        }

        DB::connection(env('HRJP_DB_CONNECTION'))->beginTransaction();
        try {
            //delete all existing record
            JobPostExpenses::where('phs_id', $request->phs_id)->delete();

            if (!empty($request->direct)) {
                foreach ($request->direct as $directExpenses) {
                    JobPostExpenses::Create(
                        [
                            'phs_id' => $request->phs_id,
                            'label' => $directExpenses['label'],
                            'type' => 1, //Direct Expenses
                            'amount' => $directExpenses['amount'],
                            'created_by' => Auth::id()
                        ]
                    );
                }
            }

            if (!empty($request->indirect)) {
                foreach ($request->indirect as $indirectExpenses) {
                    JobPostExpenses::Create(
                        [
                            'phs_id' => $request->phs_id,
                            'label' => $indirectExpenses['label'],
                            'type' => 2, //Indirect Expenses
                            'amount' => $indirectExpenses['amount'],
                            'created_by' => Auth::id()
                        ]
                    );
                }
            }

            $this->logCustomMessage('create_cost_per_hire', null, Auth::user()->name . ' has created cost per hire expenses', null, 'cost per hire created', new Activity());

            DB::connection(env('HRJP_DB_CONNECTION'))->commit();

            return response()->json([
                'text' => 'Cost per hire has been submitted.'
            ]);

        } catch (Exception $e) {
            DB::connection(env('HRJP_DB_CONNECTION'))->rollBack();
            return response()->json([
                'errors' => ['There was a problem creating expenses'],
                'message' => $e->getMessage(),
            ], 404);
        }
    }
}