<?php

namespace Suiterus\Hrjp\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Auth\Events\Verified;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Validation\ValidationException;
use Suiterus\Hrjp\Models\Applicant_account as Applicant;

class VerificationController extends Controller
{
    public function __construct()
    {
        $this->middleware('throttle:6,1')->only('verify', 'resend');
    }

    public function verify(Request $request, Applicant $applicant)
    {
        if (! URL::hasValidSignature($request)) {
            return response()->json([
                'status' => trans('verification.invalid'),
            ], 400);
        }

        if ($applicant->hasVerifiedEmail()) {
            return response()->json([
                'status' => trans('verification.already_verified'),
            ], 400);
        }

        $applicant->markEmailAsVerified();

        event(new Verified($applicant));

        return response()->json([
            'status' => trans('verification.verified'),
        ]);
    }

    public function resend(Request $request)
    {
        $this->validate($request, ['email' => 'required|email', 'authkey' => 'required|min:2|string']);

        $user = Applicant::where('email', $request->email)->first();

        if ($request->authkey !== config('app.auth_key')) {
            throw ValidationException::withMessages([
                'auth_key' => [ 'Auth key is incorrect.' ],
            ]);
        }

        if (is_null($user)) {
            throw ValidationException::withMessages([
                'email' => [trans('verification.user')],
            ]);
        }

        if ($user->hasVerifiedEmail()) {
            throw ValidationException::withMessages([
                'email' => [trans('verification.already_verified')],
            ]);
        }

        $user->sendEmailVerificationNotification();

        return response()->json(['status' => trans('verification.sent')]);
    }
}
