<?php

namespace Suiterus\Hrjp\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Suiterus\Hrjp\Models\Applicant_account as Applicant;
use Illuminate\Foundation\Auth\RegistersUsers;
use MikeMcLin\WpPassword\Facades\WpPassword;

class RegisterController extends Controller
{
    use RegistersUsers;

    public function __construct() {
        $this->middleware('guest:applicant');
    }

    protected function registered(Request $request, Applicant $applicant) {

        return response()->json($applicant);
    }

    protected function validator(array $data) {

        return Validator::make($data, [
            'email'         => 'required|email:filter|unique:hrjp_db.applicant_accounts,email,NULL,id,deleted_at,NULL',
            'firstname'     => 'required|string',
            'lastname'      => 'required|string',
            'password'      => 'required|string'
        ]);

    }

    protected function create(array $req){
        $data = Applicant::create([
            'email'     => $req['email'],
            'fname'     => $req['firstname'],
            'mname'     => $req['middlename'],
            'lname'     => $req['lastname'],
            'password'  => bcrypt($req['password']),
            'wp_password' => WpPassword::make($req['password'])
        ]);

        return $data;
    }


}
