<?php

namespace Suiterus\Hrjp\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    public function __construct() {
        $this->middleware('guest:applicant')->except('logout');
    }

    protected function attemptLogin(Request $request) {
        $token = auth('applicant')->attempt([
            'email' => $request->email,
            'password'  => $request->password
        ]);

        if(!$token) {
            return false;
        }

        auth('applicant')->setToken($token);
        
        return true;
    }

    protected function sendLoginResponse(Request $request)
    {
        $this->clearLoginAttempts($request);

        $token = (string) auth('applicant')->getToken();
        $expiration = auth('applicant')->getPayload()->get('exp');
        return response()->json([
            'token' => $token,
            'token_type' => 'bearer',
            'expires_in' => $expiration - time(),
        ]);
    }

    protected function sendFailedLoginResponse(Request $request)
    {
        throw ValidationException::withMessages([
            $this->username() => [trans('auth.failed')],
        ]);
    }

    public function logout(Request $request) {
        auth('applicant')->logout();
    }
    
}