<?php

namespace Suiterus\Hrjp\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Suiterus\Hrjp\Models\SupplementalDetails;
use Suiterus\Hrjp\Models\ApplicantRequirements;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Suiterus\Hrjp\Models\CompletionAccomplishment;
use Suiterus\Hrjp\Models\SupplementalRequirements;
use Suiterus\Hrjp\Models\SupplementalDetailsUser as SDU;
use Suiterus\Hrjp\Models\SupplementalCompletionUser as SCU;
use Suiterus\Hrjp\Models\SupplementalRequirementUser as SRU;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Hrjp\Services\ApplicantionRequirements\ApplicationService;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;



class ApplicantRequirementsController extends Controller
{

    use HasCustomLogs;

    protected $jpNotifService;

    public function __construct() {
        $this->jpNotifService = new JobPortalMailNotificationService();
    }

    public function fetch_initial_requirements(Request $req){
        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');

        try {
            $data = AC::whereHas('application', function($q){
                $q->where('step', 8)->whereIn('status', [1,2]);
            })->with(['applicantRequirements' => function($q){
                 $q->whereNotIn('status', [2, 3]);
            }, 'application' => function($q){
                $q->with(['position' => function($q){
                    $q->select('id','title');
                }])->select('id', 'applicant_id', 'position_id');
            }])->select('id', 'fname', 'lname')->paginate($paginate);

            return response()->json([
                'message' => 'Fetch successful.',
                'data' => $data
            ], 200);
        }
        catch(Exception $e) {
            return response()->json([
                'errors' => ['Can`t fetch your request as of now.'],
                'msg' => $e->getMessage()
            ], 500);
        }

    }

    public function fetch_requirements() {
        $types = SupplementalRequirements::all();

        return response()->json([
            'data'  => $types
        ]);
    }

    public function fetch_accomplishment() {
        $types = CompletionAccomplishment::all();

        return response()->json([
            'data'  => $types
        ]);
    }

    public function fetch_details() {


        $pro_license_detail = SupplementalDetails::where('purpose', 1)->get();
        $admin_position = SupplementalDetails::where('purpose', 2)->get();
        $other_position = SupplementalDetails::where('purpose', 3)->get();
        $philhealth_form = SupplementalDetails::where('purpose', 4)->get();
        $bir_form = SupplementalDetails::where('purpose', 5)->get();

        $details = array(
            'pro_license_detail'  => $pro_license_detail,
            'admin_position'  => $admin_position,
            'other_position'  => $other_position,
            'philhealth_form'  => $philhealth_form,
            'bir_form'  => $bir_form,
        );

        return response()->json([
            'data'  => $details
        ]);
    }


     //Create
     public function create_request(Request $req) {

        $valid = Validator::make($req->all(),[
            'applicant_id' => 'required|integer|exists:hrjp_db.applicant_accounts,id',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }

        DB::beginTransaction();

        try{
                $applicantReq = ApplicantRequirements::create([
                    'applicant_id'             => $req->applicant_id,
                    'message'                  => $req->message,
                    'status'                   => 1,
                    "created_by"               => Auth::id(),
                    "created_at"               => now(),
                ]);

            $applicant = $applicantReq->applicant()->first();
            $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;

            foreach($req->supplemental_req_id as $supp_req_id){
                $supplementalReq = SRU::create([
                    'applicant_req_id'         => $applicantReq->id,
                    'supplemental_req_id'      => $supp_req_id,
                    "created_at"               => now(),
                ]);
            }

            foreach($req->supplemental_detail_id as $supp_detail_id){
                $supplementalDetail = SDU::create([
                    'applicant_req_id'         => $applicantReq->id,
                    'supplemental_detail_id'   => $supp_detail_id,
                    "created_at"               => now(),
                ]);
            }

            foreach($req->supplemental_completion_id as $supp_complete_id){
                $supplementalDetail = SCU::create([
                    'applicant_req_id'                => $applicantReq->id,
                    'supplemental_completion_id'      => $supp_complete_id,
                    "created_at"                      => now(),
                ]);
            }

            $this->logCustomMessage('create_applicant_requirements', $applicantReq, Auth::user()->name . ' has created a requirement for ' . $fullName, $applicantReq, 'Create applicant requirements', new Activity());

            $message ='We have created your list of supplementary requirements. Please click the link below to view your application status.';
            $this->jpNotifService->sendMailNotification($applicant->email, $message, $fullName);

            DB::connection(env('HRJP_DB_CONNECTION'))->commit();
            return response()->json([
                'text' => 'New request record has been created.'
            ]);


        } catch(Exception $e) {
            DB::connection(env('HRJP_DB_CONNECTION'))->rollBack();
            return response()->json([
                'errors'    => ['The request could not be process.'],
                'message'   => $e->getMessage(),
            ], 500);
        }

    }


    //Fetch applicant request
    public function fetch_applicant_req(Request $req) {

        $data = ApplicantRequirements::where('applicant_id', $req->id)
        ->with(['applicantRequirementsUser.supplementalRequirements',
            'applicantDetailsUser.supplementalDetails',
            'applicantCompletionUser.supplementalCompletion'])->get();

        return response()->json([
            'data'  => $data
        ]);
    }

    public function approve_disapprove_requirement(Request $request){
        $valid = Validator::make($request->all(), [
            'id' => 'required|integer',
            'applicant_req_id' => 'required|integer',
            'status' => 'required|integer',
            'justification' => 'required|string'
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }
        DB::beginTransaction();
        try {

            $applicationRequirementServices = new ApplicationService();

            $applicationRequirementServices->updateRequirementStatus(
                $request->id,
                $request->applicant_req_id,
                $request->status,
                $request->justification,
                $request->entityName
            );

            DB::commit();
            return response()->json([
                'text'  => "Attachment has been set to disapprove."
            ]);

        } catch(Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in disapproving the Attachment.'],
                'message'   => $e->getMessage()
            ], 500);
        }
    }

}
