<?php

namespace Suiterus\Hrjp\Controllers;

use DateTime;
use Exception;
use Carbon\Carbon;
use App\Models\User;
use NumberFormatter;
use mikehaertl\pdftk\Pdf;
use Illuminate\Http\Request;
use App\Enums\ItemCodeStatus;
use App\Enums\CorporationList;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use Suiterus\Adg\Models\SM\Sector;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Hrjp\Models\Application;
use Illuminate\Support\Facades\Storage;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Models\SM\EmployeeType;
use Illuminate\Support\Facades\Validator;
use App\Enums\Jobportal\ApplicationStatus;
use Suiterus\Adg\Models\Activity\Activity;
use MikeMcLin\WpPassword\Facades\WpPassword;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Dms\Models\Repositories\Section;
use Suiterus\Adg\Models\EMI\EmployeeExtraField;
use App\Models\User_account_has_application as UHA;

use Suiterus\Dms\Models\Repositories\SectionAccess;


use Suiterus\Hrjp\Models\ApplicantExtraField as AEF;
use Suiterus\Hrjp\Models\Position_has_salary as PHS;
use App\Services\AccountSyncing\WpAccountSyncService;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Suiterus\Hrjp\Models\Applicant_account as Applicant;
use Suiterus\Hrjp\Models\ApplicantRequireAppointment as ARA;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Hrjp\Models\ApplicantExtraFieldHasMoreInfo as AEFM;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;
use ZipArchive;

class ApplicantAccountController extends Controller
{

    use HasCustomLogs;

    public function applicant(Request $request) {
        return response()->json(
            $request->user()
        );
    }
    /*
        HIRING PROCESS:
        1. Get the applicant account details
        2. Insert to ADG->users
        3. Get the new user_id
        4. Insert to employee_extra_field using the new user_id
        5. filter the applicant_extra_fields to insert to employee_extra_fields
    */
    public function hiring_process(Request $req){
        $valid = Validator::make($req->all(), [
            'id' => 'required|integer|exists:hrjp_db.applicant_accounts,id',
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }
       // DB::beginTransaction();//
        try {
            DB::connection(env('DB_CONNECTION'))->beginTransaction();
            DB::connection(env('ADG_DB_CONNECTION'))->beginTransaction();
            DB::connection(env('HRJP_DB_CONNECTION'))->beginTransaction();

            //For extra fields
            $extraField = AEF::where('applicant_id', $req->id)->whereHas('extraFieldColumn')->get();

            //For applicant account
            $applicant = Applicant::where('id', $req->id)->first();

            $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;

            //User account
            $user = User::create([
                'name'  =>  $applicant->fname . ' ' . $applicant->lname,
                'email' =>  $applicant->email,
                'password' => $applicant->password,
                'email_verified_at' => now()
            ]);

            $lowerFirstName = strtolower($applicant->fname);

            WpAccountSyncService::syncAccountsToWordpress([
                'user_login' => preg_replace('/\s+/', '.', $lowerFirstName),
                'user_pass' => $applicant->wp_password,
                'user_nicename' => preg_replace('/\s+/', '.', $lowerFirstName),
                'user_email' => $applicant->email,
                'user_url' => '',
                'user_registered' => Carbon::now(),
                'user_activation_key' => '',
                'user_status' => 0,
                'display_name' => $applicant->fname . ' ' . $applicant->lname,
            ]);

            //give role
            $user->assignRole('Employee');
            //give permissions
            $user->syncPermissions(1);
            UHA::create([
                'user_id'           =>  $user->id,
                'application_id'    =>  $req->id,
                'created_by'        =>  $req->user()->id
            ]);
            DB::connection(env('DB_CONNECTION'))->commit();

            // latest()

            $metaInfo = EmployeeMetaInfo::orderBy('employee_id','desc')->first();
            $splittedEmployeeId = $metaInfo->employee_id;

            $sector = Sector::where('status', 'active')->first();
            $application = Application::with('phs')->where('applicant_id', $req->id)->first();

            $nkti = Corporation::where('employer_id', CorporationList::NKTI)->first();
            if($nkti){
                $corp_id = $nkti->id;
            }

            $itemCode = $application->with(['position.itemCodes' => function($q){
                $q->where('status', ItemCodeStatus::ACTIVE);
            }])->first();
            if($itemCode){
                $item_code_id = $req->item_code_id;
            }else{
                $item_code_id = $application->phs->item_code_id;
            }

            //Employee Meta Info
            $employeeMetaInfo = [
                'user_id' => $user->id,
                'employee_id' => $this->generateEmpId($splittedEmployeeId),
                'employee_type' => $application->phs->employee_type,
                'branch_id' => $req->branch_id ?? null,
                'division_id' => $req->division_id,
                'department_id' => $req->department_id,
                'salary_id' => null,
                'item_code_id'  => $item_code_id,
                'position_id' => $application->phs->position_id,
                'date_hired' => Carbon::now()->format('Y-m-d'),
                'created_by' => Auth::id()
            ];

            if($sector->name == 'public'){
                $employeeMetaInfo['corp_id'] = $corp_id;
            }else {
                $employeeMetaInfo['corp_id'] = $corp_id ?? $req->corp_id;
            }
            EmployeeMetaInfo::create($employeeMetaInfo);


            //temp
            // $user = Applicant::find($req->applicant_id);
            $activeFolderId = Section::where('name', 'Active Employee')->pluck('id')->first();
            $folder_employee = [];

            $existingFolder = Section::where('name', EmployeeMetaInfo::where('user_id', $user->id)->pluck('employee_id')->first().' - '.$user->name)
            ->where('parent_id', $activeFolderId)->first();
        
            if (!$existingFolder) {
                $folder_employee[] = [
                    'name' => EmployeeMetaInfo::where('user_id', $user->id)->pluck('employee_id')->first().' - '.$user->name,
                    'parent_id' => $activeFolderId,
                    'type' => 1,
                    'status' => 1,
                    'created_by' => 2,
                    'created_at' => now(),
                    'updated_at' => now()
                ];

                Section::insert($folder_employee);

                $folderIds = Section::where('name',EmployeeMetaInfo::where('user_id', $user->id)->pluck('employee_id')->first().' - '.$user->name)->first();
                $folder_access_employee = [];

                $folder_access_employee[] = [
                    'section_id' => $folderIds['id'],
                    'user_id' => Auth::id(),
                    'access_level' => 1,
                    'created_at' => now(),
                    'updated_at' => now()
                ];

                SectionAccess::insert($folder_access_employee);
            }
            //temp

            $this->insert_extra_field($extraField, $user->id, $req->id);
            DB::connection(env('ADG_DB_CONNECTION'))->commit();


            Application::where('id', $req->application_id)->update([
                'status'    =>  ApplicationStatus::COMPLETED
            ]);

            ARA::where('applicant_id', $req->application_id)->update([
                'status'       => 2,
                'updated_at'   => now(),
            ]);

            $not_posted = 2;
            $active = 1;

            PHS::where('id', $application->phs->id)->update([
                'post_status'   => $not_posted,
            ]);

            $application->phs->itemCodes->update([
                'status'    => $active
            ]);

            $this->logCustomMessage('hire_applicant', $applicant, Auth::user()->name . ' hired an applicant ' . $fullName, $applicant, 'Hire applicant', new Activity());

            $jpNotifService = new JobPortalMailNotificationService();
            $positionTitle = $application->phs->position->title;
            $message = 'We are pleased to inform you that you have been successfully hired for the position '. $positionTitle .'. Please click the link below to view your job portal.';
            $jpNotifService->sendMailNotification($applicant->email, $message, $fullName);
            $jpNotifService->sendNotificationToAdmin('Hire Applicant JP', Auth::id(), Auth::id(), null, null, null, $fullName, $positionTitle);

            DB::connection(env('HRJP_DB_CONNECTION'))->commit();

            return response()->json([
                'test'  => "successfully hired"
            ]);

        } catch(Exception $e) {
            DB::connection(env('DB_CONNECTION'))->rollBack();
            DB::connection(env('ADG_DB_CONNECTION'))->rollBack();
            DB::connection(env('HRJP_DB_CONNECTION'))->rollBack();
            return response()->json([
                'errors'    => ['There was a problem in hiring.'],
                'message'   => $e->getMessage()
            ], 500);
        }
    }
    public function generateEmpId($latestEmpId)
    {
        // Extracting the last two digits
        $last_two_digits = '01';

        // Extracting the first two digits
        $batchNo = (int) substr($latestEmpId, 0, -4);

        // Extracting the middle part
        $increment = (int) substr($latestEmpId, -4, 2);

        if ($increment == 99) {
            $increment = 0;
            $batchNo++;
        } else {
            $increment++;
        }
        return str_pad($batchNo, 2, '0', STR_PAD_LEFT) . str_pad($increment, 2, '0', STR_PAD_LEFT) . $last_two_digits;
    }
    
    public function insert_extra_field($table, $user_id, $applicant_id){
        foreach ($table as $info => $value) {
            $eef = EmployeeExtraField::create([
                'user_id' => $user_id,
                'table_name' => $table[$info]['table_name'],
                'created_by' => Auth::id()
            ]);
            $table_id = $table[$info]['id'];
            $extraFieldColumn = AEFM::whereHas('extraField', function($q) use($applicant_id, $table_id){
                $q->where('applicant_id', $applicant_id)->where('id', $table_id);
            })->get();

            $this->extra_field_column($extraFieldColumn, $eef->id);
        }
    }
    public function extra_field_column($table, $eef_id){
        foreach ($table as $info => $value) {
            EmployeeExtraFieldColumn::create([
                'eef_id' => $eef_id,
                'field_name' =>  $table[$info]['field_name'] ?? 'N/A',
                'field_value' =>  $table[$info]['field_value'] ?? 'N/A',
                'field_type' =>   $table[$info]['field_type'] ?? 'N/A',
                'field_label' =>   $table[$info]['field_label'] ?? 'No label',
                'field_status' => 1,
                'created_by' => Auth::id(),
            ]);
        }
    }

    public function generate_application_form(Request $request) {
        $valid = Validator::make($request->all(), [
            'id' => 'required|integer|exists:hrjp_db.applicant_accounts,id',
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }
        try {
            $application = Application::with('ApplicantAccount', 'phs')->where('applicant_id', $request->id)->first();

            $applicant = $application->ApplicantAccount()->first();
            $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;

            $employee_type = EmployeeType::where('id', $application->phs->employee_type)->first();

            $salary = str_replace(',', '', $application->phs->salary->value);
            $num_to_words = new NumberFormatter('en', NumberFormatter::SPELLOUT);

            $post_due = new DateTime($application->phs->post_due);

            $uuid = uniqid();
            $uuid_1 = uniqid();
            $uuid_2 = uniqid();
            $uuid_3 = uniqid();
            $uuid_4 = uniqid();

            $data = [
                'current_date' => Carbon::now()->format('F j, Y'),
                'name' => strtoupper($application->ApplicantAccount->fname . ' ' . $application->ApplicantAccount->mname . '. ' . $application->ApplicantAccount->lname),
                'from' => $application->phs->created_at->format('m/d/Y'), 
                'to' => $post_due->format('m/d/Y'),
                'position'  => strtoupper($application->phs->position->title),
                'item_code' => $application->phs->itemCodes->item_code,
                'employee_type' => strtoupper($employee_type->title),
                'salary_words' => str_replace('-', ' ', strtoupper($num_to_words->format($salary))),
                'salary_number' => '( Php ' . number_format($salary, 2, '.', ',') . ' )',
                'salary_grade' => $application->phs->salary->salary_grade,
                'education' => $application->phs->education,
                'experience' => $application->phs->experience,
                'training' => $application->phs->training,
                'eligibility' => $application->phs->eligibility,
                'goverment_department' => 'DEPARTMENT OF HEALTH',
                'bureau_office' => 'NATIONAL KIDNEY & TRANSPLANT INSTITUTE',
                'company_address' => 'East Avenue, Diliman, Quezon City 1101, Philippines',
                'SG' => $application->phs->salary->salary_grade . "." .$application->phs->salary->step,

            ];

            $pdf = new Pdf(public_path('csc-form-template/Appointment_Form_acroform_v2.1.pdf'), config('pdftk.options'));
            $pdf_assumption = new Pdf(public_path('csc-form-template/assumption_of_duty_form.pdf'), config('pdftk.options'));
            $pdf_oath = new Pdf(public_path('csc-form-template/oath_of_office_form.pdf'), config('pdftk.options'));
            $pdf_position = new Pdf(public_path('csc-form-template/position_description.pdf'), config('pdftk.options'));

            if (!Storage::disk('appointment_form')->exists($application->ApplicantAccount->id)) {
                Storage::disk('appointment_form')->makeDirectory($application->ApplicantAccount->id);
            }

            $pdf->fillForm($data)->needAppearances()
                ->saveAs(storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/appointment_form_template' . $uuid . '.pdf'));
            $pdf_assumption->fillForm($data)->needAppearances()
                ->saveAs(storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/assumption_of_duty_template' . $uuid_1 . '.pdf'));
            $pdf_oath->fillForm($data)->needAppearances()
                ->saveAs(storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/oath_of_office_template' . $uuid_2 . '.pdf'));
            $pdf_position->fillForm($data)->needAppearances()
                ->saveAs(storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/position_description_template' . $uuid_3 . '.pdf'));

            $file_paths = [
                storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/appointment_form_template' . $uuid . '.pdf'),
                storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/assumption_of_duty_template' . $uuid_1 . '.pdf'),
                storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/oath_of_office_template' . $uuid_2 . '.pdf'),
                storage_path('app/appointment_form/' . $application->ApplicantAccount->id . '/position_description_template' . $uuid_3 . '.pdf')
            ];

            if (!Storage::disk('local')->exists('job-form-zip')) {
                Storage::disk('local')->makeDirectory('job-form-zip');
            }

            $zipFilePath = storage_path('app/job-form-zip/' . $uuid_4 . '.zip');
            $zip = new ZipArchive();
            $zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE);

            foreach ($file_paths as $file_path) {
                $file = basename($file_path);
                $zip->addFile($file_path, $file);
            }

            $zip->close();

            foreach ($file_paths as $file_path) {
                unlink($file_path);
            }

            $this->logCustomMessage('generate_appointment_form', $application, Auth::user()->name . ' generated the appointment form for applicant ' . $fullName, $application, 'Generate appointment form', new Activity());

            return response()->download(Storage::disk('local')->path('job-form-zip/'. $uuid_4 .'.zip'))->deleteFileAfterSend(true);

        } catch(Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in generating form.'],
                'message'   => $e->getMessage(),
                'line'      => $e->getLine()
            ], 500);
        }
    }

}
