<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Suiterus\Hrjp\Models\ItemCode;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Pagination\LengthAwarePaginator;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Hrjp\Models\Position_has_salary as PHS;
use Suiterus\Adg\Models\SM\Corporation;
use App\Enums\CorporationList;
class PositionController extends Controller
{
    //For positions
    public function fetch_positions(Request $request){
        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');
        $today = Carbon::now();
        $data = PHS::where('post_status', 1)->where('slots', '>', 0)
        ->whereDate('post_due', '>=', $today)
        ->orderBy('id','desc')->paginate($paginate);

        return response()->json([
            'data' => $data
        ]);
    }

    public function fetch_all_positions(Request $request){
        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');
        $today = Carbon::now();
        $posted = 1;
        $available = 3;

        $getPositions = PHS::select('position_id', 'description', 'salary', 'show_salary')->where([
            ['post_status', $posted], ['slots', '>', 0]
        ])
        ->whereDate('post_due', '>=', $today)
        ->groupBy('position_id', 'description', 'salary', 'show_salary')
        ->get();

        $data = [];
    $processedPositionIds = [];

    foreach ($getPositions as $position) {
        // Check if position_id is already processed
        if (!in_array($position->position_id, $processedPositionIds)) {
            $processedPositionIds[] = $position->position_id;
            

            $fetchPositions = PHS::where([
                ['position_id', $position->position_id], ['description', $position->description], ['salary', $position->salary['salary_grade']],
                ['post_status', $posted]
            ])->with('position', 'itemCodes')->get();
            $slots = 0;
            $itemCodes = $fetchPositions->map(function ($item) use ($available,&$slots) {
                if ($item->itemCodes->status == $available) {
                    $slots++;
                    return [
                        'hiring_manager' => $item->hiring_manager->name,
                        'post_due' => $item->post_due,
                        'post_start' => $item->post_start,
                        'agency' => Corporation::where('employer_id',CorporationList::NKTI)->pluck('name')->first(),
                        'phs_id' => $item->id,
                        'position_id' => $item->position->id,
                        'id' => $item->itemCodes->id,
                        'item_code' => $item->itemCodes->item_code,
                        'experience' => $item->experience,
                        'education' => $item->education,
                        'eligibility' => $item->eligibility,
                        'training' => $item->training,
                        'placement_of_assignment' => $item->place_of_assignment,
                        'position_title' => $item->position->title,
                        'salary' => $item->salary,
                        'description' => ItemCode::where('item_code',$item->itemCodes->item_code)->pluck('description')->first(),
                        'show_salary' => $item->show_salary
                    ];
                }
            })->filter()->toArray();

            $data[] = [
                'details' => $itemCodes,
                'position_id' => $position->position_id,
                'position_title' => $position->position->title,
                // 'show_salary' => $position->show_salary,
                // 'salary' => $position->salary,
                'slots' => $slots, // Include slots here
            ];
        }
    }

    $currentPage = LengthAwarePaginator::resolveCurrentPage();
    $pagedData = array_slice($data, ($currentPage - 1) * $paginate, $paginate);
    $data = new LengthAwarePaginator($pagedData, count($data), $paginate, $currentPage);
    $data->setPath(\Request::url());

    return response()->json([
        'data' => $data
    ]);
    }

    public function positions(){
        $data = Position::get();
        
        return response()->json([
            'data' => $data
        ]);
    }
    public function job_details() {

        return PHS::where('position_id',2)->get();
        
    }

}
