<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use App\Http\Classes\NotificationMessage;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Suiterus\Hrjp\Models\Application;
use Suiterus\Hrjp\Models\ApplicantPositionOption;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Exception;
use Illuminate\Support\Facades\DB;
use Suiterus\Hrjp\Models\Position_has_salary;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;

class ApplicationController extends Controller
{
    //Create application record
    public function create_application(Request $req){

        $valid = Validator::make($req->all(), [
            'position_id' => 'required|integer|exists:hrjp_db.positions,id',
            'applicant_id' => 'required|integer|exists:hrjp_db.applicant_accounts,id',
        ]);

        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();

        try{
            
            $application = Application::create([
                'applicant_id'    =>    $req->applicant_id,
                'status'          =>    1,
                'position_id'     =>    $req->position_id,
                'phs_id'          =>    $req->phs_id,
                'step'            =>    1,
                'created_by'      =>    $req->applicant_id,
                'created_at'      =>    now()
            ]);

            foreach($req->position_option as $option)
            $appPositionOpt = ApplicantPositionOption::create([
                'applicant_id'          =>    $application->applicant_id,
                'position_option'       =>    $option,
                'created_by'            =>    Auth::id(),
                'created_at'            =>    now()
            ]);

            $position_has_salaries = Position_has_salary::where([
                ['id', $req->phs_id], ['position_id', $req->position_id]
            ])->with('itemCodes')->get();

            foreach ($position_has_salaries as $position) {
                $data[] =[
                    'item_codes' => $position->itemCodes->item_code,
                    'description' => $position->description,
                    'salary' => $position->salary
                ];
            }

            $phs = Position_has_salary::whereId($req->phs_id)->first();
            $applicant = $application->ApplicantAccount()->first();
            $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;
            $receiverId = $phs->hiring_manager->id;

            $message = 'This email is to inform you that you have applied for '. $phs->position->title. 'position in our system, Please click the link below to view your application status.';
            $jpNotifService = new JobPortalMailNotificationService();
            $jpNotifService->sendMailNotification($applicant->email, $message, $fullName);
            $jpNotifService->sendNotificationToAdmin('Create Application JP', $receiverId, $receiverId, null, null, null, $fullName, $phs->position->title);

            DB::commit();

            return response()->json([
                'text' => 'Application created successfully!.',
                'application' => $application,
                'position_has_salary' => $data
            ]);
        }catch (Exception $e) {
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t create your Application as of now.'],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }catch(ME $e){
            return response()->json([ 
                'errors'    => ['Create an account first.']
            ], 500);
        }

    }



    //Get current step
    public function current_step(Request $req){
        try{
            $data = Application::where('applicant_id', $req->user()->id)
            ->select('id','step')->get();

            if(count($data) == 0){
                throw new ME();
            }else{
                return response()->json([
                    'text' => 'fetch successful.',
                    'data' => $data,
                ]);
            }
            
        }catch(ME $e){
            return response()->json([ 
                'errors'    => ['No account fetched.']
            ], 500);
        }
    }

    //Update current step
    public function increment_step(Request $req){
        $app = Application::where('applicant_id', $req->user()->id)
        ->where('status', 1)
        ->first();
    
        if ($app) {
            $app->increment('step');
            $applicant = $app->ApplicantAccount()->first();
            $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;
            $receiverId = $app->phs->hiring_manager->id;
            $this->sendNotificationToHiringManager($app->step, $fullName, $receiverId);
        }
        return response()->json([
            'text' => 'step increment successful.'
        ]);
    } 

    private function sendNotificationToHiringManager($step, $fullName, $receiverId)
    {   
        $jpNotifService = new JobPortalMailNotificationService();
        switch ($step) {
            case 3:
                $jpNotifService->sendNotificationToAdmin('Acknowledge Schedule JP', $receiverId, $receiverId, null, null, null, $fullName, 'Initial Interview');
                break;
    
            case 4:
                $jpNotifService->sendNotificationToAdmin('Acknowledge Status JP', $receiverId, $receiverId, null, null, null, $fullName, 'Initial Interview');
                break;
    
            case 5:
                $jpNotifService->sendNotificationToAdmin('Acknowledge Schedule JP', $receiverId, $receiverId, null, null, null, $fullName, 'Exam');
                break;

            case 6:
                $jpNotifService->sendNotificationToAdmin('Acknowledge Status JP', $receiverId, $receiverId, null, null, null, $fullName, 'Exam');
                break;
            
            case 7:
                $jpNotifService->sendNotificationToAdmin('Acknowledge Schedule JP', $receiverId, $receiverId, null, null, null, $fullName, 'Final Interview');
                break;

            case 8:
                $jpNotifService->sendNotificationToAdmin('Acknowledge Status JP', $receiverId, $receiverId, null, null, null, $fullName, 'Final Interview');
                break;

            case 9:
                $jpNotifService->sendNotificationToAdmin('Acknowledge Requirements JP', $receiverId, $receiverId, null, null, null, $fullName);
                break;
            // Add more cases as needed
            default:
                break;
        }
    }
    //fetch position
    public function position(Request $request){
        $data = Application::with('position')->where('applicant_id', $request->user()->id)->orderBy('id','desc')->first();
        return response()->json([
            'data' => $data
        ]);
    }

}
