<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\Auth;
use Suiterus\Hrjp\Models\Application;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use SoareCostin\FileVault\Facades\FileVault;
use Suiterus\Hrjp\Models\ApplicantRequirements;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Hrjp\Services\ApplicantionRequirements\ApplicationService;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;

class ApplicantRequirementsController extends Controller
{

    use HasCustomLogs;

    //Fetch Applicant Request
    public function fetch_applicant_request(Request $req) {

        $data = ApplicantRequirements::where('applicant_id', $req->user()->id)
        ->with(['applicantRequirementsUser' => function ($query){
            $query->with(['supplementalRequirements' => function ($query){
                $query->select('id','title','status','additional_info');
            }]);

        },'applicantDetailsUser' => function($query){
            $query->with(['supplementalDetails' => function ($query){
               $query->select('id','title','status','additional_info');
            }]);

        },'applicantCompletionUser' => function($query){
            $query->with(['supplementalCompletion' => function ($query){
                $query->select('id','title','status','additional_info');
            }]);

        }])->select('id','applicant_id','message','status')->get();


        return response()->json([
            'data'  => $data
        ]);
    }

    public function get_applicant_req(Request $request){
        $data = AC::where('id', $request->user()->id)->with(['applicantRequirements' => function ($query){
            $query->select('id', 'applicant_id', 'message', 'status');
        }])->select('id', 'email', 'fname', 'mname', 'lname')->orderBy('id', 'desc')->first();

        return response()->json([
            'text' => 'fetch successful.',
            'data' => $data,
        ]);
    }

    public function upload_file_attachment(Request $request){

        $applicationRequirementServices = new ApplicationService();
        $attachments = $request->file('attachment');

        foreach ($attachments as $key => $attachment) {

            $filePath = Storage::disk('supplementary_requirements')->put(Auth::id(),$attachment);
            FileVault::disk('supplementary_requirements')->encrypt($filePath);

            $applicationRequirementServices->updateFileAttachment(
                $request->entityName,
                $request->id[$key],
                $request->applicant_req_id[$key],
                $filePath,
                $request->status,
            );

        }

        $application = Application::whereHas('applicantRequirements', function ($query) use ($request) {
            $query->where('id',  $request->applicant_req_id[0]);
        })->first();
        $receiverId = $application->phs->hiring_manager->id;
        $applicant = $application->ApplicantAccount;
        $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;
        $totalIterations = count($attachments);
        if ($application) {
            (new JobPortalMailNotificationService)->sendNotificationToAdmin('Upload Requirement Files JP', $receiverId, $receiverId, null, null, null, $fullName, $totalIterations);
        }
        
        return response()->json([
            'message' => 'upload successful'
        ]);
    }

    public function download_file_attachment(Request $request){

        $applicationRequirementServices = new ApplicationService();

        $file = $applicationRequirementServices->downloadFileAttachment(
            $request->entityName,
            $request->id,
            $request->applicant_req_id
        );

        if (!$file) {
            return response()->json([
                'message' => 'Data not found'
            ], 404);

        }

        $filePath = $file->attachment . '.enc';

        $this->logCustomMessage('download_applicant_requirement', $file, Auth::user()->name . ' downloaded an applicant requirement', $file, 'Downloaded applicant requirement', new Activity());

        return response()->streamDownload(function () use($filePath){
            FileVault::disk('supplementary_requirements')->streamDecrypt($filePath);
        }, '');

    }

     //Update current step
     public function increment_step_require(Request $req){
        $applicantion = Application::where('applicant_id', $req->user()->id)->where('status',1)
        ->increment('step');

        ApplicantRequirements::where('applicant_id', $req->user()->id)->update([
            'status'       => 2,
            'updated_at'   => now(),
        ]);

        return response()->json([
            'text' => 'step increment successful.'
        ]);
    }
}
