<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Exception;
use Suiterus\Hrjp\Models\ApplicantRequirementsSchedule as ARS;
use Suiterus\Hrjp\Models\ApplicantRequireAppointment as ARA;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Suiterus\Hrjp\Models\Applicant_account;
use Suiterus\Hrjp\Models\Application;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;

class ApplicantRequirementScheduleController extends Controller
{
    //Fetching of requirements status
    public function fetch_requirement_status(Request $request){
        $data = ARS::where('applicant_id', $request->user()->id)->select('id', 'applicant_id', 'schedule', 'personnel', 'office', 'status')->orderBy('id', 'desc')->first();
        
        return response()->json([
            'data' => $data
        ]);
    }


    //Fetching of appointment status
    public function fetch_appointment_status(Request $request){
        $data = ARA::where('applicant_id', $request->user()->id)->select('id', 'applicant_id', 'schedule', 'personnel', 'office', 'status')->orderBy('id', 'desc')->first();
        
        return response()->json([
            'data' => $data
        ]);
    }


     //Update current acknowledge
     public function update_acknowledge_requirements(Request $req){

        ARS::where('applicant_id', $req->user()->id)->update([
            'status'       => 2,
            'updated_at'   => now(),
        ]);

        $applicant = Applicant_account::whereId($req->user()->id)->first();
        $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;
        $receiverId = $applicant->application->phs->hiring_manager->id;
    
        (new JobPortalMailNotificationService)->sendNotificationToAdmin('Acknowledge Schedule JP', $receiverId, $receiverId, null, null, null, $fullName, 'Submission of Requirements');

        return response()->json([
            'text' => 'Status is now Under Review'
        ]);
    }

}
