<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Suiterus\Hrjp\Models\ApplicantPreEmploymentFieldsColumn as APEFC;
use Suiterus\Hrjp\Models\ApplicantPreEmploymentFields as APEF;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\DB;

class ApplicantPreEmploymentFieldsController extends Controller
{
    public function create_pre_employment(Request $request){
        
        $user_id = $request->applicant['application']['applicant_id'];

        try{
            DB::connection(env('HRJP_DB_CONNECTION'))->beginTransaction();

            $contactInformation = $request->applicant_information['contactInformation'];
            $personalInformation = $request->applicant_information['personalInformation'];
            $skillsEducationalAttainmentGovernment = $request->applicant_information['skillsEducationalAttainment'];
            $skillsEducationalAttainmentHighestEduc = $request->applicant_information['skillsEducationalAttainment'];
            $skillsEducationalAttainmentHighestPersonal = $request->applicant_information['skillsEducationalAttainment'];
            $workExperienceTraining = $request->applicant_information['workExperienceTraining'][0];
            $referral = $request->applicant_information['referral'][0];
            $backgroundCheckNoticeFullName = $request->applicant_information['backgroundCheckNotice'];
            $backgroundCheckNoticeReference = $request->applicant_information['backgroundCheckNotice'];
            
            //contact information
            foreach ($contactInformation['contactInformationForm']['info'] as $form) {
                    $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('contact_information', $user_id);
                    
                    $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);

            }
            //personal information
            foreach ($personalInformation['personalInformationForm']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('personal_information', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);
            }

            // Government_Examination
            foreach ($skillsEducationalAttainmentGovernment['Government_Examination']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('Government_Examination', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);
            }

            // Highest_Educational_Attainment
            foreach ($skillsEducationalAttainmentHighestEduc['Highest_Educational_Attainment']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('Highest_Educational_Attainment', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);
            }

            //Personal_skills_Other_Abilities_Form
            foreach ($skillsEducationalAttainmentHighestPersonal['Personal_skills_Other_Abilities_Form']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('Skills_Educational_Attainment', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);
            }

            //skills and work experience
            foreach ($workExperienceTraining['workexpetraining']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('Work_Experience_Trainings', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);

            }

            //referral
            foreach ($referral['referral']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('referral', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);

            }

              //fullname_positionform
              foreach ($backgroundCheckNoticeFullName['fullname_positionform']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('background_check_notice', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);

            }

            //references
            foreach ($backgroundCheckNoticeReference['references']['info'] as $form) {
                $applicantPreEmploymentField = $this->insertApplicantPreEmploymentField('references', $user_id);
                
                $this->insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $form, $user_id);

            }

            DB::connection(env('HRJP_DB_CONNECTION'))->commit();


        }catch (Exception $e){
            DB::connection(env('HRJP_DB_CONNECTION'))->rollBack();
            return response()->json([
                'error' => $e->getMessage(),
                'line' => $e->getLine(),
                'user' => $user_id
            ], 400);
        }

    }

    public function insertApplicantPreEmploymentField($tableName, $user_id){
        $applicantPreEmploymentField = APEF::firstOrCreate(
            ['applicant_id' => $user_id, 'table_name' => $tableName],
            ['created_by' => $user_id, 'created_at' => now()]
        );

        return $applicantPreEmploymentField;
    }

    public function insertApplicantPreEmploymentFieldColumn($applicantPreEmploymentField, $value, $user){
        APEFC::create([
            'pre_employment_field' => $applicantPreEmploymentField->id,
            'field_name' => $value['entityName'] ?? 'N/A',
            'field_value' => $value['value'] ?? 'N/A',
            'field_type' =>  $value['type'] ?? 'N/A',
            'field_status' => 1,
            'created_by' => $user,
            'created_at' => now()
        ]);
    }

    public function fetching_pre_employment(Request $request)
    {

        $data = APEF::where('applicant_id', $request->user()->id)
        ->select('id', 'applicant_id', 'table_name')
        ->with(['preEmploymentColumn' => function ($query){
            $query->select('id', 'pre_employment_field', 'field_name', 'field_value', 'field_type', 'field_status');
        }])->get();

        return response()->json([
            'data'  => $data
        ]);
    }




}
