<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Enums\Jobportal\ExamStatus;
use App\Enums\RescheduleStatus;
use App\Http\Classes\NotificationMessage;
use Exception;
use Suiterus\Hrjp\Models\ApplicantInitialInterview as AII;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Suiterus\Hrjp\Models\ApplicantInitialInterviewReschedule as AIIR;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Hrjp\Models\Application;
use Illuminate\Support\Facades\Auth;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;

// use Suiterus\Hrjp\Models\ApplicantInitialInterview as AER;

class ApplicantInitialInterviewController extends Controller
{
    //Fetching of initial interview
    public function fetch_initial_interview_schedule(Request $request)
    {
        $data = AII::where('applicant_id', $request->user()->id)->where('status', 1)->orWhere('status', 4)->orderBy('id', 'desc')->first();
        return response()->json([
            'data' => $data
        ]);
    }

    public function fetch_position(Request $request)
    {

        $data = Application::where('applicant_id', $request->user()->id)
            ->with([('Position') => function ($query) {
                $query->select('id', 'title');
            }])->first();

        return response()->json([
            'data' => $data
        ]);
    }

    //Fetching of Initial Interview Result
    public function fetch_initial_interview_status(Request $request)
    {
        $data = AII::where('applicant_id', Auth::user()->id)->whereIn('status', [ExamStatus::PASSED, ExamStatus::FAILED, ExamStatus::TAG_TO_ANOTHER_POSITION])->orderBy('id', 'desc')->first();

        return response()->json([
            'data' => $data
        ]);
    }


    public function status_reschedule(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'schedule_id' => 'required|integer|exists:hrjp_db.applicant_initial_interviews,id',
        ]);

        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();

        try {
            $data = AII::findOrFail($request->schedule_id);
            $data->update([
                'status'          =>    4,
                'updated_by'      =>    $request->user()->id,
                'updated_at'      =>    now()
            ]);
            $data->save();
            DB::commit();

            return response()->json([
                'text' => 'Status has been changed to reschedule.',
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t update your schedule status as of now.'],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }

    // RESCHEDULE
    public function request_initial_interview_reschedule(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'schedule_id' => 'required|integer|exists:hrjp_db.applicant_initial_interviews,id',
            'reason'    =>  'required'
        ]);

        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();

        try {

            $reschedule = AIIR::create([
                'applicant_id'    =>    $request->user()->id,
                'initial_interview_schedule'   =>    $request->schedule_id,
                'reason'          =>    $request->reason,
                'status'          =>    RescheduleStatus::PENDING,
                'created_by'      =>    $request->user()->id,
                'created_at'      =>    now()
            ]);

            $applicant = $reschedule->applicant()->first();
            $receiver_id = $applicant->application->phs->hiring_manager->id;
            $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;

            $message = 'You have requested a reschedule for the initial interview. We will notify you if it is accepted. If not, please attend the given schedule.';
            $jpNotifService = new JobPortalMailNotificationService();
            $jpNotifService->sendMailNotification($applicant->email, $message, $fullName);
            $jpNotifService->sendNotificationToAdmin('Request Reschedule JP', $receiver_id, $receiver_id, null, null, null, $fullName, 'Initial Interview');

            DB::commit();

            return response()->json([
                'text' => 'Reschedule request has been successfully created.',
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json(
                [   
                    'line' => $e->getLine(),
                    'errors' => ['Can`t create your request as of now.'],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }

    //decline

    public function decline_position(Request $req)
    {

        $old_position = Application::findOrFail($req->applicant_id);
        Application::where('applicant_id', $req->applicant_id)->update([
            'position_id'       => $old_position->old_position_id,
            'old_position_id'   => null,
            'updated_at'        => now(),
        ]);

        $applicantion = Application::where('applicant_id', $req->user()->id)->where('status', 1)
            ->increment('step');

        return response()->json([
            'text' => 'Successfully Declined.'
        ]);
    }

    public function fetch_initial_resched_count(Request $request)
    {
        $data = AIIR::where('applicant_id',  $request->user()->id)->whereIn('status', [1, 2, 3])->orderBy('id', 'desc')->get();

        return response()->json([
            'count_reschedule' => count($data)
        ]);
    }
}
