<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Suiterus\Hrjp\Models\ApplicantExtraFieldHasMoreInfo as AEFM;
use Suiterus\Hrjp\Models\ApplicantExtraField as AEF;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\DB;

class ApplicantExtraFieldController extends Controller
{
    
    public function create(Request $request){
        $user_id = $request->user()->id;
        
        try{
            DB::connection(env('HRJP_DB_CONNECTION'))->beginTransaction();
        
            $personalInformation = $request->personalInformation;
            $familyBackground = $request->familyBackground;
            $educationalBackground = $request->educationalBackground;
            $civilServices = $request->civilServices;
            $workExperiences = $request->workExperiences;
            $voluntaryWorks = $request->voluntaryWorks;
            $learningDevelopments = $request->learningDevelopments;
            $otherInformation = $request->otherInformation;
            $choices = $request->choices;
            $references = $request->references;
            $governmentID = $request->governmentID;
        
            // This snippet inserts personal information key
            foreach ($personalInformation as $personalInfoFormKey => $personalInfoFormValue) {
                if ($personalInfoFormKey != "title") {

                    // if statement for tablename with similar JSON structure while the else if has different json structure
                    if ($personalInformation[$personalInfoFormKey]['tableName'] == 'personal_information' || $personalInformation[$personalInfoFormKey]['tableName'] == 'other_information' || $personalInformation[$personalInfoFormKey]['tableName'] == 'pds_choices') {

                        $applicantExtraField = $this->insertApplicantExtraField($personalInformation[$personalInfoFormKey]['tableName'], $user_id);
                        
                        foreach ($personalInformation[$personalInfoFormKey]['info'] as $infoKey => $infoValue) {  
                            if (!$infoValue['skip']) {
                                $this->insertApplicantExtraFieldColumn($applicantExtraField, $infoValue, $user_id);
                            }
                        }

                        // This is only unique for radio buttons with other details and similar json structure
                        if ($personalInformation[$personalInfoFormKey]['tableName'] == 'pds_choices') {
                            foreach ($personalInformation[$personalInfoFormKey]['info'] as $infoKey => $infoValue) {  
                                if (!$infoValue['skip']) {
                                    AEFM::create([
                                        'applicant_extra_field' => $applicantExtraField->id,
                                        'field_name' => $infoValue['otherDetails']['entityName'] ?? 'N/A',
                                        'field_value' => $infoValue['otherDetails']['value'] ?? 'N/A',
                                        'field_type' =>  $infoValue['otherDetails']['type'] ?? 'N/A',
                                        'field_status' => 1,
                                        'created_by' => $user_id,
                                        'created_at' => now()
                                    ]);
                                    
                                }
                            }
                        }
                    }else if($personalInformation[$personalInfoFormKey]['tableName'] == 'addresses'){
                        foreach ($personalInformation[$personalInfoFormKey]['info'] as $addressFormKey => $addressFormValue) {

                            $tableName = $addressFormValue['title'] == 'Residential Address' ? 'residential_address' : 'permanent_address';

                            $applicantExtraField = $this->insertApplicantExtraField($tableName, $user_id);

                            foreach ($addressFormValue['addressInfo'] as $addressInfoKey => $addressInfoValue) {
                                if (!$addressInfoValue['skip']) {
                                    $this->insertApplicantExtraFieldColumn($applicantExtraField, $addressInfoValue, $user_id);
                                }
                            }
                        }
                        
                    }
                }
            }

            // This snippet inserts Family Background key
            foreach ($familyBackground as $familyFormKey => $familyBackgroundFormValue) {
                if ($familyFormKey != 'title') {
                    if ($familyFormKey == 'children') {
                        foreach ($familyBackground[$familyFormKey] as $familyObjKey => $familyObjValue) {

                            $applicantExtraField = $this->insertApplicantExtraField($familyObjValue['tableName'], $user_id);
                            
                            foreach ($familyObjValue['info'] as $infoKey => $infoValue) {
                                if (!$infoValue['skip']) {
                                    $this->insertApplicantExtraFieldColumn($applicantExtraField, $infoValue, $user_id);
                                }
                            }
                        }
                    }else {
                        
                        $applicantExtraField = $this->insertApplicantExtraField($familyBackground[$familyFormKey]['tableName'], $user_id);
                        
                        foreach ($familyBackgroundFormValue['info'] as $infoKey => $infoValue) {
                            if (!$infoValue['skip']) {
                                $this->insertApplicantExtraFieldColumn($applicantExtraField, $infoValue, $user_id);
                            }
                        }
                    }
                }
            }
        

            foreach ($educationalBackground as $educationFormKey => $educationFormValue) {
                if ($educationFormKey != 'title') {
                    $tableName = $educationFormKey;
                    foreach ($educationalBackground[$educationFormKey] as $educationKey => $educationValue) {

                        $applicantExtraField = $this->insertApplicantExtraField($tableName, $user_id);
                        
                        foreach ($educationValue as $education => $value) {
                            foreach ($value['info'] as $infoKey => $infoValue) {
                                if (!$infoValue['skip']) {
                                    $this->insertApplicantExtraFieldColumn($applicantExtraField, $infoValue, $user_id);
                                }
                            }
                        }
                    }
                }
            }
        

            $this->insertC2AndC3($user_id, $civilServices);
            $this->insertC2AndC3($user_id, $workExperiences);
            $this->insertC2AndC3($user_id, $voluntaryWorks);
            $this->insertC2AndC3($user_id, $learningDevelopments);
            $this->insertC2AndC3($user_id, $otherInformation);

            $applicantExtraField = $this->insertApplicantExtraField('choices', $user_id);

            foreach ($choices as $choicesKey) {
                foreach ($choicesKey['choices'] as $choicesValue) {
                    $choiceInfo = [];
                    $choiceInfo['entityName'] = $choicesValue['entityName'];
                    $choiceInfo['value'] = $choicesValue['value'];
                    $choiceInfo['type'] = 'radio';

                    $this->insertApplicantExtraFieldColumn($applicantExtraField, $choiceInfo, $user_id);
                    
                    $choiceDetails = [];
                    $choiceDetails['entityName'] = $choicesValue['choiceDetails']['entityName'];
                    $choiceDetails['value'] = $choicesValue['choiceDetails']['value'];
                    $choiceDetails['type'] = 'text';

                    $this->insertApplicantExtraFieldColumn($applicantExtraField, $choiceDetails, $user_id);
                    
                }
            }
            
            foreach ($references as $referenceKey) {
                $applicantExtraField = $this->insertApplicantExtraField($referenceKey['tableName'], $user_id);
                foreach ($referenceKey as $info => $infoVal) {
                    if ($info != 'tableName') {
                        foreach ($referenceKey[$info] as $infoKey => $infoValue) {
                            $this->insertApplicantExtraFieldColumn($applicantExtraField, $infoValue, $user_id);
                        }
                    }
                }
            }   

            foreach ($governmentID as $objKey => $objValue) {
                $applicantExtraField = $this->insertApplicantExtraField($objValue['tableName'], $user_id );
                foreach ($objValue as $key => $value) {
                    if ($key != 'tableName') {
                        foreach ($objValue[$key] as $attributeKey => $attributeValue) {
                            if ($attributeKey == 'info') {
                                foreach ($attributeValue as $infoKey => $infoValue) {
                                    if (!$infoValue['skip']) {
                                        $this->insertApplicantExtraFieldColumn($applicantExtraField, $infoValue, $user_id);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            
            DB::connection(env('HRJP_DB_CONNECTION'))->commit();

        } catch (Exception $e){
            DB::connection(env('HRJP_DB_CONNECTION'))->rollBack();
            return response()->json([
                'error' => $e->getMessage(),
                'line' => $e->getLine(),
                'user' => $user_id
            ], 400);
        }
    }

    public function insertC2AndC3($user, $information){
        foreach ($information as $objKey => $objValue) {
            $applicantExtraField = $this->insertApplicantExtraField($objValue['tableName'], $user );

            foreach ($objValue as $key => $value) {
                if ($key != 'tableName') {
                    foreach ($objValue[$key] as $attributeKey => $attributeValue) {
                        if ($attributeKey == 'info') {
                            foreach ($attributeValue as $infoKey => $infoValue) {
                                if (!$infoValue['skip']) {
                                    $this->insertApplicantExtraFieldColumn($applicantExtraField, $infoValue, $user);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function insertApplicantExtraField($tableName, $user_id){
        $applicantExtraField = AEF::create([
            'applicant_id' => $user_id,
            'table_name' => $tableName,
            'created_by' => $user_id,
            'created_at' => now()
        ]);

        return $applicantExtraField;
    }

    public function insertApplicantExtraFieldColumn($applicantExtraField, $value, $user){
        AEFM::create([
            'applicant_extra_field' => $applicantExtraField->id,
            'field_name' => $value['entityName'] ?? 'N/A',
            'field_value' => $value['value'] ?? 'N/A',
            'field_type' =>  $value['type'] ?? 'N/A',
            'field_status' => 1,
            'created_by' => $user,
            'created_at' => now()
        ]);
    }

    public function createFiles(Request $request){
        $user_id = $request->user()->id;
        $files = $request->all();

        $validator = Validator::make($files, [
            'diploma_file' => $files['diploma_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:10000',
            'birth_file' => $files['birth_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:10000',
            'civil_file' => $files['civil_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:10000',
            'nbi_file' => $files['nbi_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:10000',
            'training_file' => $files['training_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:10000',
            'resume_file' => $files['resume_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx',
            'work_file' => $files['work_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()
            ], 400);
        }

        $applicantExtraField = $this->insertApplicantExtraField('file_attachments',$user_id);

        foreach ($request->all() as $key => $value) {
            if ($files[$key] != 'null' && $files[$key] != null && isset($files[$key])){
                $path = $files[$key]->store('applicant_pds_file_attachment/' . $user_id . '/' . $key);
                DB::beginTransaction();
                try {
                    AEFM::create([
                        'applicant_extra_field' => $applicantExtraField->id,
                        'field_name' => $key,
                        'field_value' => $path,
                        'field_type' =>  'file',
                        'field_status' => 1,
                        'created_by' => $user_id,
                    ]);

                    DB::commit();

                }catch(Exception $e){
                    DB::connection(env('HRJP_DB_CONNECTION'))->rollBack();
                    return response()->json([
                        'error' => $e->getMessage(),
                        'line' => $e->getLine(),
                    ], 400);
                } 
            }
        }
        return response()->json([
            'text' => "Successfully uploaded files."
        ], 200);
    }

    public function getRecord(Request $request){
        $data = AEF::with(['applicant' => function($q){
            $q->select('id', 'fname', 'lname');
        }])->whereHas('applicant', function($q){
            $q->whereHas('application', function($q){
                $q->where('status', 1);
            });
        })->where('applicant_id', $request->user()->id)->where('table_name', 'personal_information')->
        orderBy('id', 'desc')->first();

        return response()->json([
            'text' => 'fetch successful.',
            'data' => $data,
        ]);
    }

    public function getRequirement(Request $request){
        $data = AC::with('application', 'fileAttachment', 'fileAttachment.extraFieldColumn')->whereHas('fileAttachment', function($q) use($request){
            $q->where('applicant_id', $request->user()->id)->whereHas('extraFieldColumn', function($q){
                $q->where('field_name', 'coe_file');
            });
        })->
        where('id', $request->user()->id)->select('id', 'fname', 'lname')->orderBy('id', 'desc')->first();

        return response()->json([
            'text' => 'fetch successful.',
            'data' => $data,
        ]);
    }
    
    public function setRequirementFiles(Request $request){
        $user_id = $request->user()->id;
        $files = $request->all();

        $validator = Validator::make($files, [
            'coe_file' => $files['coe_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:10000',
            'marriage_file' => $files['marriage_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:10000',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()
            ], 400);
        }

        $data = AEF::where('applicant_id', $user_id)->where('table_name', 'file_attachments')->without('extraFieldColumn')->orderBy('id', 'desc')->first();

        
        DB::beginTransaction();
        try { 
            $ef_id = null;
            if(is_null($data)){
                $applicantExtraField = $this->insertApplicantExtraField('file_attachments',$user_id);
                $ef_id = $applicantExtraField->id;
            }else{
                $ef_id = $data->id;
            }

            foreach ($request->all() as $key => $value) {
                if ($files[$key] != 'null' && $files[$key] != null && isset($files[$key])){
                    $path = $files[$key]->store('applicant_pds_file_attachment/' . $user_id . '/' . $key);
                    AEFM::create([
                        'applicant_extra_field' => $ef_id,
                        'field_name' => $key,
                        'field_value' => $path,
                        'field_type' =>  'file',
                        'field_status' => 1,
                        'created_by' => $user_id,
                    ]);
                }else{
                    AEFM::create([
                        'applicant_extra_field' => $ef_id,
                        'field_name' => $key,
                        'field_value' => 'N/A',
                        'field_type' =>  'file',
                        'field_status' => 1,
                        'created_by' => $user_id,
                    ]);
                }
            }

            DB::commit();
            return response()->json([
                'text'  =>  "Successfully uploaded files.",
            ], 200);

        }catch(Exception $e){
            DB::connection(env('HRJP_DB_CONNECTION'))->rollBack();
            return response()->json([
                'error' => $e->getMessage(),
                'line' => $e->getLine(),
                'data'  => $data
            ], 400);
        } 
        
    }
}
