<?php

namespace Suiterus\Hrjp\Controllers\Applicant;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Enums\Jobportal\ExamStatus;
use App\Enums\RescheduleStatus;
use Exception;
use Suiterus\Hrjp\Models\Applicant_exam_interview as AEI;
use Suiterus\Hrjp\Models\ApplicantExamInterviewReschedule as AIR;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;

class ApplicantExamInterviewController extends Controller
{
    //Fetching of schedule
    public function fetch_interview_schedule(Request $request)
    {
        $data = AEI::where('applicant_id', $request->user()->id)->where('status', 1)->orWhere('status', 4)->orderBy('id', 'desc')->first();

        return response()->json([
            'data' => $data
        ]);
    }

    //Fetching of Exam Result
    public function fetch_interview_status(Request $request)
    {
        $data = AEI::where('applicant_id', $request->user()->id)->whereIn('status', [ExamStatus::PASSED, ExamStatus::FAILED, ExamStatus::TAG_TO_ANOTHER_POSITION])->orderBy('id', 'desc')->first();

        return response()->json([
            'data' => $data
        ]);
    }

    //Change status for request of reschedule
    public function status_reschedule(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'schedule_id' => 'required|integer|exists:hrjp_db.applicant_exam_interviews,id',
        ]);

        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();

        try {
            $data = AEI::findOrFail($request->schedule_id);
            $data->update([
                'status'          =>    4,
                'updated_by'      =>    $request->user()->id,
                'updated_at'      =>    now()
            ]);
            $data->save();
            DB::commit();

            return response()->json([
                'text' => 'Status has been changed to reschedule.',
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t update your schedule status as of now.'],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }

    //RESCHEDULE
    public function request_reschedule(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'schedule_id'   =>  'required|integer|exists:hrjp_db.applicant_exam_interviews,id',
            'reason'    =>  'required'
        ]);

        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();

        try {
            $reschedule = AIR::create([
                'applicant_id'    =>    $request->user()->id,
                'interview_schedule'    =>    $request->schedule_id,
                'reason'                =>    $request->reason,
                'status'                =>    RescheduleStatus::PENDING,
                'created_by'            =>    $request->user()->id,
                'created_at'            =>    now()
            ]);

            $applicant = $reschedule->applicant()->first();
            $receiver_id = $applicant->application->phs->hiring_manager->id;
            $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;

            $message = 'You have requested a reschedule for the final interview. We will notify you if it is accepted. If not, please attend the given schedule.';
            $jpNotifService = new JobPortalMailNotificationService();
            $jpNotifService->sendMailNotification($applicant->email, $message, $fullName);
            $jpNotifService->sendNotificationToAdmin('Request Reschedule JP', $receiver_id, $receiver_id, null, null, null, $fullName, 'Final Interview');

            DB::commit();

            return response()->json([
                'text' => 'Reschedule request has been successfully created.',
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t create your request as of now.'],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }

    public function fetch_exam_resched_count(Request $request)
    {
        $data = AIR::where('applicant_id',  $request->user()->id)->whereIn('status', [1, 2, 3])->orderBy('id', 'desc')->get();

        return response()->json([
            'count_reschedule' => count($data)
        ]);
    }
}
