<?php

namespace Suiterus\Fdg;

use Illuminate\Support\ServiceProvider;

class SuiterusFDGProvider extends ServiceProvider
{
    public function getAllFiles($dir, &$results = array()) {
        $files = scandir($dir);

        foreach ($files as $key => $value) {
            $path = realpath($dir . DIRECTORY_SEPARATOR . $value);
            if (!is_dir($path)) {
                include $path;
            } else if ($value != "." && $value != "..") {
                $this->getAllFiles($path, $results);
            }
        }

        return $results;
    }
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->getAllFiles(__DIR__.'/Routes/');
        $this->getAllFiles(__DIR__.'/Controllers/');
        $this->getAllFiles(__DIR__.'/Models/');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadMigrationsFrom(__DIR__.'/Migrations/');
    }
}
