<?php
use Suiterus\Fdg\Controllers\AM\CompanyController as CC;
use Suiterus\Fdg\Controllers\AM\FiscalYearController as FY;
use Suiterus\Fdg\Controllers\AM\AccountingPeriodController as AP;
use Suiterus\Fdg\Controllers\AM\FinanceBookController as FB;
use Suiterus\Fdg\Controllers\AM\PaymentTermController as PT;
use Suiterus\Fdg\Controllers\AM\AccountingDimensionController as AD;

Route::group([ 'prefix' => 'api', 'middleware' => 'auth:api' ], function(){

//functions
Route::group([ 'prefix' => 'functions' ], function(){

//FDG
        Route::group([ 'prefix' => 'financial'/* , 'middleware' => [ 'role:developer|Junior Accountant' ] */ ], function(){
            //Accounting Masters Routes
            Route::group([ 'prefix' => 'am', 'middleware' => [] ],function(){
                //company routes
                Route::prefix('company')->group(function(){
                    //create
                    Route::post('create', [ CC::class, 'create_company' ])->middleware('permission:can create company');
                    //init list
                    Route::post('list', [ CC::class, 'init_list_company' ])->middleware('permission:can list company');
                    //search
                    Route::post('search', [ CC::class, 'search_company' ])->middleware('permission:can search company');
                    //edit
                    Route::post('edit', [CC::class, 'edit_company']);
                    //view
                    Route::post('view', [ CC::class, 'view_company' ]);
                    //delete
                    Route::post('delete', [ CC::class, 'delete_company' ]);
    
                    //Trashed
                    //Init list
                    Route::post('deleted/list', [ CC::class, 'init_list_deleted_company']);
                    //Restore 
                    Route::post('deleted/restore', [ CC::class, 'restore_deleted_company']);
                    //Delete
                    Route::post('deleted/delete', [ CC::class, 'delete_deleted_company']);
    
                    
                });
                 //fiscal year
                 Route::prefix('fiscalyear')->group(function(){
                    //create
                    Route::post('create', [FY::class, 'create_fiscal'])->middleware('permission:can create fiscal year');
                    //init list
                    Route::post('list', [ FY::class, 'init_list_fiscal'])->middleware('permission:can list fiscal year');
                    //search
                    Route::post('search', [FY::class, 'search_fiscal'])->middleware('permission:can search fiscal year');
                    //search company
                    Route::post('company/search', [ FY::class, 'search_company' ]);
                    //edit
                    Route::post('edit', [FY::class, 'edit_fiscal']);
                    //view
                    Route::post('view', [ FY::class, 'view_fiscal' ]);
                    //delete
                    Route::post('delete', [ FY::class, 'delete_fiscal' ]);
  

                    //Trashed
                    //Init list
                    Route::post('deleted/list', [ FY::class, 'init_list_deleted_fiscal']);
                    //Restore 
                    Route::post('deleted/restore', [ FY::class, 'restore_deleted_fiscal']);
                    //Delete
                    Route::post('deleted/delete', [ FY::class, 'delete_deleted_fiscal']);

               
                });
                //Accounting Period
                Route::prefix('accountingperiod')->group(function(){
                    //create
                    Route::post('create', [AP::class, 'create'])->middleware('permission:can create accounting period');
                    //list
                    Route::post('list', [AP::class, 'init_list_accounting_period'])->middleware('permission:can list accounting period');
                    //search
                    Route::post('search', [AP::class, 'search_accounting_period'])->middleware('permission:can search accounting period');
                    //search company
                    Route::post('company/search', [ AP::class, 'search_company' ])->middleware('permission:can search company accounting period');
                    //edit
                    Route::post('edit', [AP::class, 'edit_accounting_period']);
                    //view
                    Route::post('view', [ AP::class, 'view_accounting_period' ]);
                    //delete
                    Route::post('delete', [ AP::class, 'delete_accounting_period']);


                    //Trashed
                    //Init list
                    Route::post('deleted/list', [ AP::class, 'init_list_deleted_accounting_period']);
                    //Restore 
                    Route::post('deleted/restore', [ AP::class, 'restore_deleted_accounting_period']);
                    //Delete
                    Route::post('deleted/delete', [ AP::class, 'delete_deleted_accounting_period']);
                });




                //accounting dimension routes
                Route::prefix('accountingdimension')->group(function(){
                    //create
                    Route::post('create', [AD::class, 'create'])->middleware('permission:can create accounting dimension');
                    //list
                    Route::post('list', [AD::class, 'init_list_accounting_dimension'])->middleware('permission:can list accounting dimension');
                    //search
                    Route::post('search', [AD::class, 'search_accounting_dimension'])->middleware('permission:can search accounting dimension');
                    //search company
                    Route::post('company/search', [ AD::class, 'search_company' ]);
                    //edit
                    Route::post('edit', [AD::class, 'edit_accounting_dimension']);
                    //view
                    Route::post('view', [ AD::class, 'view_accounting_dimension' ]);
                    //delete
                    Route::post('delete', [ AD::class, 'delete_accounting_dimension' ]);

                    // Trashed
                    //init list
                    Route::post('deleted/list', [ AD::class, 'init_list_deleted_accounting_dimension' ]);
                    //restore 
                    Route::post('deleted/restore', [ AD::class, 'restore_deleted_accounting_dimension']);
                    //delete
                    Route::post('deleted/delete', [ AD::class, 'delete_deleted_accounting_dimension']);
                });

                //finance book routes
                Route::prefix('financebook')->group(function() {
                    //create
                    Route::post('create', [FB::class, 'create_finance_book'])->middleware('permission:can create finance book');
                    //init list
                    Route::post('list', [FB::class, 'init_list_finance_book'])->middleware('permission:can list finance book');
                    //search
                    Route::post('search', [FB::class, 'search_finance_book'])->middleware('permission:can search finance book');
                    //edit
                    Route::post('edit', [FB::class, 'edit_finance_book']);
                    //view
                    Route::post('view', [ FB::class, 'view_finance_book' ]);
                    //delete
                    Route::post('delete', [ FB::class, 'delete_finance_book' ]);
                    
                    // Trashed
                    //init list
                    Route::post('deleted/list', [ FB::class, 'init_list_deleted_finance_book' ]);
                    //restore 
                    Route::post('deleted/restore', [ FB::class, 'restore_deleted_finance_book']);
                    //delete
                    Route::post('deleted/delete', [ FB::class, 'delete_deleted_finance_book']);
                });

                //payment term routes
                Route::prefix('payment_term')->group(function(){
                    //create
                    Route::post('create', [ PT::class, 'create_payment_term' ])->middleware('permission:can create payment term');
                    //list
                    Route::post('list', [ PT::class, 'list_payment_term' ])->middleware('permission:can list payment term');
                    //search
                    Route::post('search', [ PT::class, 'search_payment_term' ])->middleware('permission:can search payment term');
                    //edit
                    Route::post('edit', [PT::class, 'edit_payment_term']);
                    //view
                    Route::post('view', [ PT::class, 'view_payment_term' ]);
                    //delete
                    Route::post('delete', [ PT::class, 'delete_payment_term' ]);

                    // Trashed
                    //init list
                    Route::post('deleted/list', [ PT::class, 'init_list_deleted_payment_term' ]);
                    //restore 
                    Route::post('deleted/restore', [ PT::class, 'restore_deleted_payment_term']);
                    //delete
                    Route::post('deleted/delete', [ PT::class, 'delete_deleted_payment_term']);
                });
            });
        });
    });
});



?>