<?php

namespace App\Models\FDG\AM\FiscalYear;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class FY_Company extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'fdg_db';

    protected $fillable = [
        'company_id'
    ];

    protected $with = [
        'company'
    ];

    public function company(){
        return $this->belongsTo('App\Models\FDG\AM\Company');
    }

    public function fiscal_year(){
        return $this->belongsTo('App\Models\FDG\AM\FiscalYear');
    }

}
