<?php

namespace Suiterus\Fdg\Models\AM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FiscalYear extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'fdg_db';

    protected $fillable = [
        'name',
        'status',
        'is_short',
        'year_start',
        'year_end',
        'companies'
    ];

    protected $with = [
        'fy_company'
    ];

    public function getYearStartAtAttribute($value){
        return Carbon::parse($value)
        ->timezone('Asia/Manila')
        ->toDateTimeString();
    }

    public function getYearEndAtAttribute($value){
        return Carbon::parse($value)
        ->timezone('Asia/Manila')
        ->toDateTimeString();
    }

    public function fy_company(){
        return $this->hasMany('Suiterus\Fdg\Models\AM\FiscalYear\FY_Company');
    }


}
