<?php

namespace Suiterus\Fdg\Models\AM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{

    use HasFactory, SoftDeletes;

    protected $connection = 'fdg_db';

    protected $fillable = [
        'company',
        'domain',
        'abbrevation',
        'parent_company',
        'default_tax',
        'type_of_entry',
        'ccoabo',
        'tax_id',
        'holiday_list',
        'date_of_establishment',
        'date_of_incorporation',
        'fax',
        'phone_number',
        'email',
        'website',
        'description',
    ];

    public function fiscalYear(){
        return $this->hasMany('Suiterus\Fdg\Models\AM\FiscalYear\FY_Company');
    }

    public function accountingDimension(){
        return $this->hasMany('Suiterus\Fdg\Models\AM\AccountingDimension\AD_Company');
    }
}
