<?php

namespace App\Models\FDG\AM\AccountingDimension;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class AD_Company extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'fdg_db';

    protected $fillable = [
        'company_id',
        'default_dim',
        'mandatory_balance',
        'mandatory_profit'
    ];

    protected $with = [
        'company'
    ];

    public function company()
    {
        return $this->belongsTo('App\Models\FDG\AM\Company');
    }

    public function accounting_dimension(){
        return $this->belongsTo('App\Models\FDG\AM\AccountingDimension');
    }
}
