<?php

namespace Suiterus\Fdg\Models\AM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountingDimension extends Model
{
    use HasFactory, Softdeletes;

    protected $connection = 'fdg_db';

    protected $fillable = [
        'docu_type',
        'name',
        'dimensions',
        'companies'
    ];

    protected $with = [
        'ad_company'
    ];

    public function ad_company()
    {
        return $this->hasMany('Suiterus\Fdg\Models\AM\AccountingDimension\AD_Company');
    }
}
