<?php

namespace Suiterus\Fdg\Controllers\AM;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use App\Http\Controllers\Controller;
use Suiterus\Fdg\Models\AM\FinanceBook as FB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Exception;
use Validator;
use Auth;
use DB;

class FinanceBookController extends Controller
{
    public function view_finance_book(Request $req)
    {

        $valid = Validator::make($req->all(), [
            'id'    =>  'required|numeric',
            'name'  =>  'required|string'
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }
        DB::beginTransaction();
        try {
            try {
                $fb = FB::where(['id' => $req->id, 'name' => $req->name])->firstOrFail();
                DB::commit();
                return response()->json([
                    'data'  =>  $fb,
                ]);
            } catch (ME $ee) {
                DB::rollback();
                return response()->json([
                    'errors'    =>  ['Finance Book does not exist']
                ], 404);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Can`t create your entry as of now. Contact the developer to fix it. Error Code : AM-comp-0x05'],
                'msg'   =>  $e->getMessage()
            ], 500);
        }
    }

    public function create_finance_book(Request $req)
    {

        $valid = Validator::make($req->all(), [
            'name' => 'required|min:2|max:255|unique:fdg_db.finance_books',
            'status' => 'required',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors' => $valid->errors(),
            ], 400);
        }

        DB::beginTransaction();
        try {
            FB::create([
                'name' => $req->name,
                'status' => $req->status && $req->status === 'Active' ? 1 : 0,
            ]);

            DB::commit();
            $user = $req->user();
            return response()->json([
                'text' => 'New Finance Book Created!',
            ]);
        } catch (Exception $ex) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Can`t create your entry as of now. Contact the developer to fix it. Error Code : AM-comp-0x01'],
                'message'   =>  $ex->getMessage()
            ], 400);
        }
    }

    public function edit_finance_book(Request $req)
    {

        $valid = Validator::make($req->all(), [
            'name' => 'required|min:2|max:255|string|unique:fdg_db.finance_books,name,' . $req->id,
            'status' => 'required',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors' => $valid->errors(),
            ], 400);
        }

        DB::beginTransaction();
        try {
            try {
                $finance_book = FB::findOrFail($req->id);

                $finance_book->update([
                    'name' => $req->name,
                    'status' => $req->status && $req->status == 'Active' ? 1 : 0
                ]);


                DB::commit();
                $user = $req->user();
                return response()->json([
                    'text' => 'Finance Book Updated!',
                ]);
            } catch (ME $e) {
                DB::rollback();
                return response()->json(
                    [
                        'errors' => ['Finance Book not found!.'],
                    ],
                    404
                );
            }
        } catch (Exception $ex) {
            DB::rollback();
            return response()->json([
                'errors' => ['Something went wrong']
            ], 500);
        }
    }

    public function init_list_finance_book(Request $req)
    {

        $paginate = $req->paginate ?  intval($req->paginate) : 10;
        $page = $req->page ? $req->page : 0;
        $sort = $req->sorting ? $req->sorting : 'id_desc';

        if ($req->sorting === 'name_asc') {
            $data = FB::orderBy('name', 'asc')->paginate($paginate);
        } else if ($req->sorting === 'name_desc') {
            $data = FB::orderBy('name', 'desc')->paginate($paginate);
        } else if ($req->sorting === 'created_at_asc') {
            $data = FB::orderBy('created_at', 'asc')->paginate($paginate);
        } else if ($req->sorting === 'created_at_desc') {
            $data = FB::orderBy('created_at', 'desc')->paginate($paginate);
        } else if ($req->sorting === 'id_asc') {
            $data = FB::orderBy('id', 'asc')->paginate($paginate);
        } else {
            $data = FB::orderBy('id', 'desc')->paginate($paginate);
        }

        return response()->json([
            'message' => 'Fetch successful.',
            'sorting' => $sort,
            'data' => $data,
        ]);
    }

    public function search_finance_book(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'keyword'   =>  'required|min:2'
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {
            DB::commit();
            return response()->json([
                'text'  =>  'Search successful!',
                'data'  =>  FB::where('name', 'LIKE', '%' . $req->keyword . '%')->paginate(config('app.manuals.pagination')),
                'keyword' => $req->keyword
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong while processing your request. Error Code : AM-comp-0x02'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }

    public function init_list_deleted_finance_book()
    {
        $deleted_finance_book = FB::onlyTrashed()->orderBy('deleted_at', 'desc')->paginate(config('app.manuals.pagination'));
        return response()->json([
            'text'  =>  'fetch successful.',
            'data'  =>  $deleted_finance_book
        ]);
    }

    public function restore_deleted_finance_book(Request $req)
    {

        DB::beginTransaction();
        try {
            try {
                $fb = FB::onlyTrashed()->findOrFail($req->id)->restore();
                DB::commit();
                return response()->json([
                    'text'  =>  'Finance Book has been restored.',
                ]);
            } catch (ME $e) {
                DB::rollback();
                return response()->json([
                    'errors' => ['Finance Book not found!.'],
                ], 404);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong while processing your request. Error Code : AM-comp-0x03'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }

    public function delete_finance_book(Request $req)
    {
        DB::beginTransaction();
        try {
            try {
                $fb = FB::findOrFail($req->id);
                $fb->delete();
                DB::commit();

                $user = $req->user();
                return response()->json([
                    'text'  =>  'Finance Book has been deleted.',

                ]);
            } catch (ME $e) {
                DB::rollback();
                return response()->json(
                    [
                        'errors' => ['Finance Book not found!.'],
                    ],
                    404
                );
            }
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong while processing your request. Error Code : AM-comp-0x03'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }

    public function delete_deleted_finance_book(Request $req)
    {
        DB::beginTransaction();
        try {
            try {
                $fb = FB::onlyTrashed()->findOrFail($req->id)->forceDelete();
                DB::commit();
                return response()->json([
                    'text'  =>  'Finance Book has been deleted.',
                ]);
            } catch (ME $e) {
                DB::rollback();
                return response()->json([
                    'errors' => ['Finance Book not found!.'],
                ], 404);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong while processing your request. Error Code : AM-comp-0x03'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }
}
