<?php

namespace Suiterus\Fdg\Controllers\AM;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Fdg\Models\AM\AccountingDimension as AD;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Suiterus\Fdg\Models\AM\Company;
use Validator;
use Auth;
use DB;

class AccountingDimensionController extends Controller
{

	public function view_accounting_dimension(Request $req){

        $valid = Validator::make($req->all(),[
            'id'    =>  'required|numeric',
            'name'  =>  'required|string'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                $ad = AD::where([ 'id' => $req->id, 'name' => $req->name ])->firstOrFail();
				DB::commit();
                return response()->json([
                    'data'  =>  $ad
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Accounting Dimension does not exist' ]
                ],404);
            }
        }catch(\Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : AM-comp-0x05' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

	public function create(Request $req)
	{
		$valid = Validator::make($req->all(), [
			'ref' 	=> 'required|max:255',
			'dimen' => 'required|max:255',
			'company' => 'required:array'
		]);
		if ($valid->fails()) {
			return response()->json([
				'errors' => $valid->errors()
			], 400);
		}

		$dim = $req->company;
		for ($i=0; $i < count($dim) ; $i++) { 
			$val[]=($dim[$i]["defdimen"]);
		}
		$dimensions = implode(", ",$val);

		DB::beginTransaction();
		try {
			$ad = AD::create([
				'name' => $req->dimen,
				'docu_type' => $req->ref,
				'dimensions' => $dimensions
			]);
			$error = [];
			foreach ($req->company as $comp) {
				try {
					$company = Company::where(['company' => $comp['company']])->firstOrFail();
					$ad->ad_company()->create([
						'company_id'    =>  $company->id,
						'default_dim' => $comp['defdimen'],
						'mandatory_balance' => $comp['balance'],
						'mandatory_profit' => $comp['profit']
					]);
				} catch (ME $e) {
					$error[] = [
						'Company [' . $comp['company'] . '] not found'
					];
				}
			}
			if (count($error) > 0) {
				DB::rollback();
				return response()->json([
					'text'  =>  'Accounting Dimension values inserted!. But ' . count($error) . ' of companies not exists.<br> ' . implode(',', $error)
				]);
			} else {
				DB::commit();
				$user = $req->user();
				return response()->json([
					'text'  =>  'Accounting Dimension values inserted!.',
					'data' => $req->all()
				]);
			}
		} catch (\Exception $e) {
			DB::rollback();
			return response()->json([
				'errors'  =>  ['Can`t create your entry as of now. Contact the developer to fix it. Error Code : AM-accntd-0x01'],
				'message'   =>  $e->getMessage()
			], 400);
		}
	}

	public function edit_accounting_dimension(Request $req) {

		$valid = Validator::make($req->all(), [
			'docu_type' 	=> 'required|max:255',
			'name' => 'required|max:255',
			'ad_company' => 'required:array'
		]);
		if ($valid->fails()) {
			return response()->json([
				'errors' => $valid->errors()
			], 400);
		}

		$dim = $req->ad_company;
		for ($i=0; $i < count($dim) ; $i++) { 
			$val[]=($dim[$i]["default_dim"]);
		}
		$dimensions = implode(", ",$val);

        DB::beginTransaction();
        try {
            try {
                $accounting_dimension = AD::findOrFail($req->id);

                $accounting_dimension->update([
					'name' => $req->name,
					'docu_type' => $req->docu_type,
					'dimensions' => $dimensions
                ]);

				$accounting_dimension->ad_company()->forceDelete();
				$error = [];

				foreach ($req->ad_company as $comp) {

					if(count($req->deleted_company_dimension) > 0){
                        for($i = 0; $i < count($req->deleted_company_dimension); $i++){
                            if(strcmp($comp['company']['company'], $req->deleted_company_dimension[$i]) == 0){
                                $req->deleted_company_dimension = array_diff($req->deleted_company_dimension,  [$comp['company']['company']]);
                            }
                        }
                    }

					if($comp['company'] != 'Sample Company'){
						try {
							$company = Company::where(['company' => $comp['company']['company']])->firstOrFail();
							$accounting_dimension->ad_company()->create([
								'company_id'    =>  $company->id,
								'default_dim' => $comp['default_dim'],
								'mandatory_balance' => $comp['mandatory_balance'],
								'mandatory_profit' => $comp['mandatory_profit']
							]);
						} catch (ME $e) {
							$error[] = [
								'Company [' . $comp['company']['company'] . '] not found'
							];
						}
					}
				}

                $final_deleted_companies = count($req->deleted_company_dimension);

				if (count($error) > 0) {
					DB::rollback();
					return response()->json([
						'text'  =>  'Accounting Dimension values updated!. But ' . count($error) . ' of companies not exists.<br> ' . implode(',', $error)
					]);
				} else {
					DB::commit();
					$user = $req->user();
					return response()->json([
						'text'  =>  'Accounting Dimension values updated!.',
						'data' => $req->all()
					]);
				}
            } catch (ME $e) {
                DB::rollback();
                return response()->json(
                    [
                        'errors' => ['Accounting Dimension not found!.'],
                    ],
                    404
                );
            }
        } catch (Exception $ex) {
            DB::rollback();
            return response()->json([
                'errors' => ['Something went wrong']
            ], 500);
        }
	}

	public function init_list_accounting_dimension(Request $req)
	{

        $paginate = $req->paginate ?  intval($req->paginate) : 10;
        $page = $req->page ? $req->page : 0;
        $sort = $req->sorting ? $req->sorting : 'id_desc';

		if ($req->sorting === 'name_asc') {
			$data = AD::orderBy('name', 'asc')->paginate($paginate);
		} else if ($req->sorting === 'name_desc') {
			$data = AD::orderBy('name', 'desc')->paginate($paginate);
		} else if ($req->sorting === 'docu_type_asc') {
			$data = AD::orderBy('docu_type', 'asc')->paginate($paginate);
		} else if ($req->sorting === 'docu_type_desc') {
			$data = AD::orderBy('docu_type', 'desc')->paginate($paginate);
		} else if ($req->sorting === 'dimension_asc') {
			$data = AD::orderBy('dimensions', 'asc')->paginate($paginate);
		} else if ($req->sorting === 'dimension_desc') {
			$data = AD::orderBy('dimensions', 'desc')->paginate($paginate);
		} else if ($req->sorting === 'created_at_asc') {
			$data = AD::orderBy('created_at', 'asc')->paginate($paginate);
		} else if ($req->sorting === 'created_at_desc') {
			$data = AD::orderBy('created_at', 'desc')->paginate($paginate);
		} else if ($req->sorting === 'id_asc') {
			$data = AD::orderBy('id', 'asc')->paginate($paginate);
		} else {
			$data = AD::orderBy('id', 'desc')->paginate($paginate);
		}

        return response()->json([
            'message' => 'Fetch successful.',
            'sorting' => $sort,
            'data' => $data,
        ]);
	}

	public function search_accounting_dimension(Request $req)
	{
		$valid = Validator::make($req->all(), [
			'keyword'   =>  'required|min:2'
		]);
		if ($valid->fails()) {
			return response()->json([
				'errors'    =>  $valid->errors()
			], 400);
		}

		DB::beginTransaction();
		try {
			DB::commit();
			return response()->json([
				'text'  =>  'Search successful!',
				'data'  =>  AD::where('name', 'LIKE', '%' . $req->keyword . '%')->paginate(config('app.manuals.pagination')),
				'keyword' => $req->keyword
			]);
		} catch (\Exception $e) {
			DB::rollback();
			return response()->json([
				'errors'    =>  ['Something went wrong while processing your request. Error Code : AM-comp-0x02'],
				'message'   =>  $e->getMessage()
			], 500);
		}
	}

	public function search_company(Request $req)
	{
		$valid = Validator::make($req->all(), [
			'keyword'   =>  'required|string|min:2'
		]);
		if ($valid->fails()) {
			return response()->json([
				'errors'    =>  $valid->errors()
			], 400);
		}
		return response()->json([
			'data'  =>  Company::where('company', 'LIKE', '%' . $req->keyword . '%')->limit(5)->cursor()
		]);
	}

	public function init_list_deleted_accounting_dimension(){
        $deleted_accounting_dimension = AD::onlyTrashed()->orderBy('deleted_at', 'desc')->paginate(config('app.manuals.pagination'));
        return response()->json([
            'text'  =>  'fetch successful.',
            'data'  =>  $deleted_accounting_dimension
        ]);
    }

	public function restore_deleted_accounting_dimension(Request $req){

        DB::beginTransaction();
        try{
            try{
                $ad = AD::onlyTrashed()->findOrFail($req->id);
				$ad->ad_company()->restore();
                $ad->restore();
				
                DB::commit();
                return response()->json([
                    'text'  =>  'Accounting Dimension has been restored.',
					'data' => $ad
                ]);
            }catch (ME $e) {
                DB::rollback();
                return response()->json([
                    'errors' => ['Accounting Dimension not found!.'],
                ],404);
            }
        }catch(\Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong while processing your request. Error Code : AM-comp-0x03' ],
                'message'   =>  $e->getMessage()
            ],500);
        }
    }

    public function delete_accounting_dimension(Request $req){
        DB::beginTransaction();
        try{
            try{
                $ad = AD::findOrFail($req->id);
                $ad->ad_company()->delete();
                $ad->delete();
                DB::commit();

                $user = $req->user();
                return response()->json([
                    'text'  =>  'Accounting Dimension has been deleted.',
                    
                ]);
            }catch (ME $e) {
                DB::rollback();
                return response()->json(
                    [
                        'errors' => ['Accounting Dimension not found!.'],
                    ],
                    404
                );
            }
        }catch(\Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong while processing your request. Error Code : AM-comp-0x03' ],
                'message'   =>  $e->getMessage()
            ],500);
        }
    }

	public function delete_deleted_accounting_dimension (Request $req){
        DB::beginTransaction();
        try{
            try{
                $ad = AD::onlyTrashed()->findOrFail($req->id);
				$ad->ad_company()->forceDelete();
				$ad->forceDelete();
				
                DB::commit();
                return response()->json([
                    'text'  =>  'Accounting dimension has been deleted.',
                ]);
            }catch (ME $e) {
                DB::rollback();
                return response()->json([
                        'errors' => ['Accounting dimension not found!.'],
                ],404);
            }
        }catch(\Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong while processing your request. Error Code : AM-comp-0x03' ],
                'message'   =>  $e->getMessage()
            ],500);
        }
    }
}
