<?php
namespace Suiterus\Dms\Validator;

use League\MimeTypeDetection\FinfoMimeTypeDetector;
use Suiterus\Dms\Helper\AllowedMimeType;

class MimeTypeSniffer {
    public static function validate($attribute, $value){

        $detector = new FinfoMimeTypeDetector();

        $mimetype = $detector->detectMimeType($value->getClientOriginalName(), '');

        $allowedMimeType = explode(',', AllowedMimeType::getAllowedMimeTypes());

        return in_array($mimetype, $allowedMimeType);
    }
}
