<?php

//section manager

use App\Events\Notifications;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MailController;
use App\Models\AccessManagement\RoleLeader;
use Suiterus\Dms\Controllers\FileController;
use Suiterus\Dms\Controllers\FileController as FC;
use Suiterus\Dms\Controllers\GlobalSearchController;
use Suiterus\Dms\Controllers\Archive\ArchiveController;
use Suiterus\Dms\Controllers\Feature\FeatureController;
use Suiterus\Dms\Models\GenerateLink\GenerateDriveLink;
use App\Http\Controllers\Systems\NotificationController;
use Suiterus\Dms\Controllers\Trashbin\TrashbinController;
use YlsIdeas\FeatureFlags\Controllers\FeaturesController;
use Suiterus\Dms\Controllers\Approvals\ApprovalController;

//configuration
use Suiterus\Dms\Controllers\Dashboard\DashboardController;
use Suiterus\Dms\Controllers\Repositories\FolderController;
use Suiterus\Dms\Controllers\Approvals\RemarkTypeController;
use Suiterus\Dms\Controllers\Configuration\FaviconController;
use Suiterus\Dms\Controllers\CustomForm\CustomFormController;

//file viewingss
use Suiterus\Dms\Controllers\Approvals\UserApproverController;

//user management
use Suiterus\Dms\Controllers\SectionManager\ForwardController;
use Suiterus\Dms\Models\ApprovalTemplate\UserApprovalTemplate;
use Suiterus\Dms\Controllers\AccessManagement\UserTypeController;
use Suiterus\Dms\Controllers\Configuration\ConfigEmailController;
use Suiterus\Dms\Controllers\Repositories\PublicFolderController;
use Suiterus\Dms\Controllers\Configuration\DocumentTypeController;
use Suiterus\Dms\Controllers\CustomForm\CustomFormValueController;
use Suiterus\Dms\Controllers\Repositories\PrivateFolderController;
use Suiterus\Dms\Controllers\SectionManager\BatchUploadController;
use Suiterus\Dms\Controllers\SectionManager\FileCommentController;
use Suiterus\Dms\Controllers\SectionManager\FileVersionController;
use App\Http\Controllers\Auth\UserController as AuthUserController;
use Suiterus\Dms\Controllers\AccessManagement\FileAccessController;
use Suiterus\Dms\Controllers\AccessManagement\PermissionController;
use Suiterus\Dms\Controllers\AccessManagement\UserAccessController;
use Suiterus\Dms\Controllers\NotificationMessagesController as NMC;
use Suiterus\Dms\Controllers\Repositories\PersonalFolderController;
use Suiterus\Dms\Controllers\GenerateLink\GenerateFileLinkController;
use Suiterus\Dms\Controllers\Signatory\FileSignatorySigneeController;
use Suiterus\Dms\Controllers\Configuration\AllowedFileTypesController;
use Suiterus\Dms\Controllers\Configuration\ConfigHeaderLogoController;
use Suiterus\Dms\Controllers\GenerateLink\GenerateDriveLinkController;
use Suiterus\Dms\Controllers\AccessManagement\UserManagementController;
use Suiterus\Dms\Controllers\Configuration\ConfigLoginHeaderController;
use Suiterus\Dms\Controllers\LevelOfApprover\LevelOfApproverController;
//notidication messages
use App\Http\Controllers\AccessManagement\GroupManagement\RoleController;
use App\Http\Controllers\AccessManagement\GroupManagement\UserController;
use Suiterus\Dms\Controllers\OtherAttachments\OtherAttachmentsController;
use App\Http\Controllers\AccessManagement\GroupManagement\SystemController;
use App\Http\Controllers\AccessManagement\UserManagement\LicenseController;
use App\Http\Controllers\AccessManagement\GroupManagement\SectionController;
use App\Http\Controllers\AccessManagement\GroupManagement\SubRoleController;
use Suiterus\Dms\Controllers\SectionManager\RepositoriesController as SM_RC;
use Suiterus\Dms\Controllers\ApprovalTemplate\UserApprovalTemplateController;
use Suiterus\Dms\Controllers\ApprovalTemplate\UserHasAdminTemplateController;
use Suiterus\Dms\Controllers\ApprovalTemplate\AdminApprovalTemplateController;
use App\Http\Controllers\AccessManagement\GroupManagement\RoleLeaderController;
use App\Http\Controllers\AccessManagement\GroupManagement\ModelHasRoleController;
use App\Http\Controllers\AccessManagement\GroupManagement\SystemModuleController;
use App\Http\Controllers\AccessManagement\GroupManagement\RoleHasSystemController;
use App\Http\Controllers\AccessManagement\GroupManagement\SectionAccessController;
use App\Http\Controllers\AccessManagement\GroupManagement\SubRoleModuleController;
use Suiterus\Dms\Controllers\LevelOfApprover\DocumentTypeApprovalTemplateController;
use App\Http\Controllers\AccessManagement\GroupManagement\RoleSystemModuleController;

Route::group(['prefix' => 'api', 'middleware' => 'auth:api'], function () {

    //sample route
    Route::post('sample', function () {
        echo "hi";
    });

    //functions
    Route::group(['prefix' => 'functions'], function () {

        Route::group(['prefix' => 'shared-with-me'], function () {
            Route::group(['prefix' => 'list'], function () {
                Route::get('file', [FileAccessController::class, 'listSharedFiles']);
                Route::get('folder', [SectionAccessController::class, 'listSharedFolders']);
            });
        });

        Route::group(['prefix' => 'upload'], function() {
            Route::post('batch-upload', [BatchUploadController::class, 'batchUpload'])->middleware(['permission:upload document personal drive|upload document private drive|upload document shared drive']);
        });

        Route::group(['prefix' => 'search'], function () {
            Route::get('file', [GlobalSearchController::class, 'searchFile']);
            Route::get('folder', [GlobalSearchController::class, 'searchFolder']);
        });

        //fetch all template repo
        Route::post('template/all', [SM_RC::class, 'templates_all']);
        //user search
        Route::post('user/search', [SM_RC::class, 'user_search']);
        //section manager
        Route::group(['prefix' => 'section-manager'], function () {
            //repositories
            //section
            Route::group(['prefix' => 'section'], function () {
                //list
                Route::post('list', [SM_RC::class, 'section_list']);
                //create
                Route::post('create', [SM_RC::class, 'section_create']);
                //update
                Route::post('update', [SM_RC::class, 'section_update']);
                //config
                Route::post('config', [SM_RC::class, 'section_config']);
                //config access level
                Route::post('config/access_level', [SM_RC::class, 'section_config_access_level']);
                //config delete access level
                Route::post('config/access_level/delete', [SM_RC::class, 'section_config_access_level_delete']);
                //upload single file
                Route::post('file/single/upload', [SM_RC::class, 'single_upload']);
            });
        });
        //Repositories
        Route::group(['prefix' => 'repositories'], function () {
            // private repositories
            Route::group(['prefix' => 'private-drive'], function () {
                Route::get('fetch-user-with-license', [AuthUserController::class, 'fetchUserWithLicense']);
                Route::post('root-private-create', [FolderController::class, 'createRootFolder'])->middleware(['permission:create private drive folder']);
                Route::post('file/upload', [FileController::class, 'file_upload'])->middleware(['permission:upload document private drive']);
                Route::get('fetch_allowed', [AllowedFileTypesController::class, 'fetchAllowedTypes']);
                Route::post('user_search', [PrivateFolderController::class, 'user_search']);
                Route::post('list-private-repo', [PrivateFolderController::class, 'list_root_folder']);
                Route::post('list/folders', [PrivateFolderController::class, 'list_private_folders']);
                Route::get('root-list', [PrivateFolderController::class, 'fetch_folders']);
                Route::post('view', [FolderController::class, 'folderView']);
                Route::post('fetch-user-access', [UserAccessController::class, 'checkFileAccess']);
                Route::post('fetch-section-access', [UserAccessController::class, 'checkSectionAccess']);
                Route::post('folder/fetch-access', [FolderController::class, 'fetchHasSectionAccess']);

                Route::group(['prefix' => 'configure'], function () {
                    Route::group(['prefix' => 'access'], function () {
                        Route::post('folders', [PrivateFolderController::class, 'configure_access'])->middleware(['permission:folder configure private drive']);
                        Route::post('files', [FC::class, 'configure_access'])->middleware(['permission:configure document private drive']);
                    });
                    Route::group(['prefix' => 'fetch'], function () {
                        Route::group(['prefix' => 'folder'], function () {
                            Route::post('groups', [PrivateFolderController::class, 'fetch_groups']);
                            Route::post('users', [PrivateFolderController::class, 'fetch_users']);
                        });
                        Route::group(['prefix' => 'file'], function () {
                            Route::post('groups', [FC::class, 'fetch_groups']);
                            Route::post('users', [FC::class, 'fetch_users']);
                        });
                    });
                });
                Route::group(['prefix' => 'search'], function () {
                    Route::post('folders', [PrivateFolderController::class, 'search_folder']);
                    Route::post('files', [PrivateFolderController::class, 'search_file']);
                });
                Route::group(['prefix' => 'fetch'], function () {
                    Route::post('folders', [FolderController::class, 'fetchFolder']);
                    Route::post('files', [FolderController::class, 'fetchFolderFile']);
                });
                Route::group(['prefix' => 'move'], function () {
                    Route::post('files', [FileController::class, 'move_file'])->middleware(['permission:move file private drive']);
                    Route::post('folders', [FolderController::class, 'move_folder'])->middleware(['permission:move folder private drive']);
                });
                Route::group(['prefix' => 'copy'], function () {
                    Route::post('files', [FileController::class, 'copy_file'])->middleware(['permission:copy file private drive']);
                    Route::post('folders', [FolderController::class, 'copy_folder'])->middleware(['permission:copy folder private drive']);
                });
                Route::group(['prefix' => 'delete'], function () {
                    Route::post('folders', [FolderController::class, 'deleteFolder'])->middleware(['permission:delete folder private drive']);
                    Route::post('files', [FileController::class, 'deleteDocument'])->middleware(['permission:delete document private drive']);
                });
                Route::post('rename-folder', [FolderController::class, 'renameFolder'])->middleware(['permission:edit folder name private drive']);
                Route::group(['prefix' => 'auto-folder'], function () {
                    Route::post('approvals', [PrivateFolderController::class, 'approvalFetchFiles']);
                    Route::post('forwards', [PrivateFolderController::class, 'forwardFetchFiles']);
                    Route::post('signatory', [PrivateFolderController::class, 'assignSignatoryFetchFiles']);
                });
            });
            //shared drived
            Route::group(['prefix' => 'shared-drive'], function () {
                Route::post('root-shared-create', [FolderController::class, 'createRootFolder'])->middleware(['permission:create shared drive folder']);
                Route::group(['middleware' => ['permission:upload document shared drive']], function () {
                    //upload Files
                    Route::post('file/upload', [FileController::class, 'file_upload'])->middleware(['permission:upload document shared drive']);
                    Route::get('fetch_allowed', [AllowedFileTypesController::class, 'fetchAllowedTypes']);
                });
                //File access
                Route::post('fetch-user-access', [UserAccessController::class, 'checkFileAccess']);
                Route::post('fetch-section-access', [UserAccessController::class, 'checkSectionAccess']);

                Route::get('fetch-user-with-license', [AuthUserController::class, 'fetchUserWithLicense']);
                Route::post('list-shared-repo', [PublicFolderController::class, 'list_root_folder']);
                Route::post('list/folders', [PublicFolderController::class, 'list_public_folders']);
                //List and view
                Route::post('view', [FolderController::class, 'folderView']);

                Route::group(['prefix' => 'search'], function () {
                    Route::post('folders', [PublicFolderController::class, 'search_folder']);
                    Route::post('files', [PublicFolderController::class, 'search_file']);
                });
                Route::group(['prefix' => 'fetch'], function () {
                    Route::post('folders', [FolderController::class, 'fetchFolder']);
                    Route::post('files', [FolderController::class, 'fetchFolderFile']);
                });
                Route::group(['prefix' => 'move'], function () {
                    Route::post('files', [FileController::class, 'move_file'])->middleware(['permission:move file shared drive']);
                    Route::post('folders', [FolderController::class, 'move_folder'])->middleware(['permission:move folder shared drive']);
                });
                Route::group(['prefix' => 'copy'], function () {
                    Route::post('files', [FileController::class, 'copy_file'])->middleware(['permission:copy file shared drive']);
                    Route::post('folders', [FolderController::class, 'copy_folder'])->middleware(['permission:copy folder shared drive']);
                });
                Route::group(['prefix' => 'delete'], function () {
                    Route::post('files', [FileController::class, 'deleteDocument'])->middleware(['permission:delete document shared drive']);
                    Route::post('folders', [FolderController::class, 'deleteFolder'])->middleware(['permission:delete folder shared drive']);
                });
                Route::post('rename-folder', [FolderController::class, 'renameFolder'])->middleware(['permission:edit folder name shared drive']);
            });
            //personal drive
            Route::group(['prefix' => 'personal-drive'], function () {
                Route::group(['prefix' => 'search'], function () {
                    Route::post('folders', [PersonalFolderController::class, 'search_folder']);
                    Route::post('files', [PersonalFolderController::class, 'search_file']);
                    Route::post('root-files', [PersonalFolderController::class, 'root_search_file']);
                });
                Route::group(['prefix' => 'fetch'], function () {
                    Route::post('folders', [FolderController::class, 'fetchFolder']);
                    Route::post('files', [FolderController::class, 'fetchFolderFile']);
                });
                Route::group(['prefix' => 'delete'], function () {
                    Route::post('files', [FileController::class, 'deleteDocument'])->middleware(['permission:delete document personal drive']);
                    Route::post('folders', [FolderController::class, 'deleteFolder'])->middleware(['permission:delete folder personal drive']);
                });
                Route::group(['prefix' => 'move'], function () {
                    Route::post('files', [FileController::class, 'move_file'])->middleware(['permission:move file personal drive']);
                    Route::post('folders', [FolderController::class, 'move_folder'])->middleware(['permission:move folder personal drive']);
                });
                Route::group(['prefix' => 'copy'], function () {
                    Route::post('files', [FileController::class, 'copy_file'])->middleware(['permission:copy file personal drive']);
                    Route::post('folders', [FolderController::class, 'copy_folder'])->middleware(['permission:copy folder personal drive']);
                });
                Route::post('view', [FolderController::class, 'folderView']);
                Route::post('list/folders', [PersonalFolderController::class, 'list_folders']);
                Route::post('create-personal-folder', [FolderController::class, 'createRootFolder'])->middleware(['permission:create personal drive folder']);
                Route::post('list-personal-repo', [PersonalFolderController::class, 'list_root_folder']);
                Route::post('rename-folder', [FolderController::class, 'renameFolder'])->middleware(['permission:edit folder name personal drive']);
                Route::post('folder/check-duplicate', [FolderController::class, 'checkDuplicateFolder']);
            });
        });
        //Dashboard
        Route::group(['prefix' => 'dashboard'], function () {
            Route::get('fetch-user-with-license', [AuthUserController::class, 'fetchUserWithLicense']);
            Route::post('file/upload', [FileController::class, 'file_upload'])->middleware(['permission:upload document personal drive']);
            Route::post('file/check-duplicate', [FC::class, 'check_duplicate_file']);
            Route::get('fetch_allowed', [AllowedFileTypesController::class, 'fetchAllowedTypes']);
            //file access
            Route::post('fetch-user-access', [UserAccessController::class, 'checkFileAccess']);
            Route::post('fetch-section-access', [UserAccessController::class, 'checkSectionAccess']);
        });

            //Viewing
            Route::group([ 'prefix' => 'viewing' ], function(){
                Route::post('view', [FC::class, 'view_document'])->middleware(['permission:file information personal drive|file information private drive|file information shared drive']);
                Route::post('view/file/all', [FC::class, 'file_approval_info']);
                Route::post('download', [FC::class, 'file_download_encrypted'])->middleware(['permission:download document private drive|download document shared drive|download document personal drive']);
                Route::post('fetch/url', [FC::class, 'file_download']);
                Route::get('play-video', [FC::class, 'playVideo']);
                Route::post('delete', [FC::class, 'deleteDocument'])->middleware(['permission:delete document private drive|delete document shared drive|delete document personal drive']);
                Route::post('update/file/check-duplicate', [FC::class, 'check_rename_duplicate_file'])->middleware(['permission:update document private drive|update document shared drive|update document personal drive']);
                Route::post('update/version', [FC::class, 'update_document_version'])->middleware(['permission:update document private drive|update document shared drive|update document personal drive']);
                Route::post('update/file', [FC::class, 'update_document'])->middleware(['permission:update document private drive|update document shared drive|update document personal drive']);
                Route::get('view/recently_uploaded', [FC::class, 'view_recently_uploaded']);
                Route::post('view/version', [FileVersionController::class, 'view_version']);
                Route::post('list/version', [FileVersionController::class, 'version_list'])->middleware(['permission:list file version private drive|list file version shared drive|list file version personal drive']);
                Route::post('file/version/upload',[FileVersionController::class,'file_version_upload'])->middleware(['permission:upload new version private drive|upload new version shared drive|upload new version personal drive']);
                

            //Load Folder tab index (Only Folders)
            Route::post('view-list-only-updated-folders', [FC::class, 'fetch_updated_folders']);

            //Load File tab index (Only files)
            Route::post('view-list-only-updated-files', [FC::class, 'fetch_updated_files']);

            //file comment
            Route::group(['prefix' => 'comments'], function () {
                Route::post('upload/comment', [FileCommentController::class, 'file_comment_upload'])->middleware(['permission:file comment private drive|file comment shared drive|file comment personal drive']);
                Route::post('fetch/comment', [FileCommentController::class, 'file_comment_list'])->middleware(['permission:list file comment private drive|list file comment shared drive|list file comment personal drive']);
            });
        });

        Route::group(['prefix' => 'email'], function () {
            Route::post('send_default_email_template', [MailController::class, 'sendDefaultEmailTemplate']);
        });

        Route::group(['prefix' => 'configuration'], function () {
            Route::middleware('role:Super Admin')->group(function () {
                Route::post('send_test_email_template', [MailController::class, 'sendTestEmail']);
                Route::post('createOrUpdateHeader', [ConfigHeaderLogoController::class, 'updateCreate']);
                Route::post('createOrUpdateEmail', [ConfigEmailController::class, 'updateCreateEmail']);
                Route::post('delete_file_type', [AllowedFileTypesController::class, 'delete_file_type']);
                Route::post('init_list_config_email', [ConfigEmailController::class, 'init_list_config_email']);
                Route::get('fetch_path', [ConfigHeaderLogoController::class, 'fetch_path']);
                Route::post('file_download', [ConfigHeaderLogoController::class, 'file_download']);
                Route::post('createOrUpdateFavicon', [FaviconController::class, 'updateCreate']);
                
                Route::group(['prefix' => 'login'], function () {
                    Route::get('fetch-path', [ConfigLoginHeaderController::class, 'fetchPath']);
                    Route::post('download', [ConfigLoginHeaderController::class, 'download']);
                    Route::post('createOrUpdateLoginHeader', [ConfigLoginHeaderController::class, 'updateCreate']);
                });
                
            });
            Route::post('file_download_favicon', [FaviconController::class, 'file_download']);
        });

        Route::group(['prefix' => 'configuration', 'middleware' => ['role:Super Admin|Admin']], function () {
            Route::post('create_file_type', [AllowedFileTypesController::class, 'create_file_type']);
            Route::post('init_list_file_types', [AllowedFileTypesController::class, 'init_list_file_types']);
        });

        Route::group(['prefix'=> 'configuration'], function(){
            Route::get('fetch_path_favicon', [FaviconController::class, 'fetch_path']);
        });

        //Forwards
        Route::group(['prefix' => 'forwards', 'middleware' => ['permission:forward document private drive|forward document shared drive|forwad document personal drive']], function () {
            Route::group(['prefix' => 'list'], function () {
                Route::post('user', [ForwardController::class, 'list_internal_user']);
                Route::post('group', [ForwardController::class, 'list_internal_group']);
            });
            Route::post('view-forwarded', [ForwardController::class, 'view_forwarded']);
            Route::post('update', [ForwardController::class, 'update_status']);
            Route::post('send', [ForwardController::class, 'forward_document'])->middleware(['permission:forward document private drive|forward document shared drive|forwad document personal drive']);
            Route::post('fetch/history', [ForwardController::class, 'forward_history']);
        });

        //Access Management
        Route::group(['prefix' => 'access-management'], function () {
            Route::group(['prefix' => 'assign'], function () {

                Route::post('file-access', [FileAccessController::class, 'assignFileAccess']);
            });
            Route::get('fetch-permissions', [PermissionController::class, 'fetch_permissions']);
            Route::group(['prefix' => 'group-management'], function () {
                Route::group(['prefix' => 'role-has-system-dms'], function () {
                    Route::post('create', [RoleHasSystemController::class, 'create']);
                    Route::get('fetch-by-system', [RoleHasSystemController::class, 'fetchBySystem']);
                    Route::get('paginate', [RoleHasSystemController::class, 'paginate']);
                    Route::post('update', [RoleHasSystemController::class, 'update']);
                });
                Route::group(['prefix' => 'role'], function () {
                    Route::post('create', [RoleController::class, 'create']);
                    Route::post('update', [RoleController::class, 'update']);
                    Route::post('delete', [RoleController::class, 'delete']);
                    Route::get('fetch', [RoleController::class, 'fetch']);
                    Route::get('paginate', [RoleController::class, 'paginate']);
                });

                Route::group(['prefix' => 'role-leader'], function () {
                    Route::post('create', [RoleLeaderController::class, 'create']);
                    Route::post('update', [RoleLeaderController::class, 'update']);
                });

                Route::group(['prefix' => 'system'], function () {
                    Route::post('create', [SystemController::class, 'create']);
                    Route::post('update', [SystemController::class, 'update']);
                    Route::post('delete', [SystemController::class, 'delete']);
                    Route::get('paginate', [SystemController::class, 'paginate']);
                    Route::get('fetch', [SystemController::class, 'fetch']);
                });

                Route::group(['prefix' => 'system-module'], function () {
                    Route::post('create', [SystemModuleController::class, 'create']);
                    Route::post('update', [SystemModuleController::class, 'update']);
                    Route::post('delete', [SystemModuleController::class, 'delete']);
                    Route::get('fetch', [SystemModuleController::class, 'fetch']);
                    Route::get('paginate', [SystemModuleController::class, 'paginate']);
                });

                Route::group(['prefix' => 'role-system-module'], function () {
                    Route::post('create', [RoleSystemModuleController::class, 'create']);
                    Route::post('delete', [RoleSystemModuleController::class, 'delete']);
                    Route::get('fetch-by-role-id', [RoleSystemModuleController::class, 'fetchByRoleID']);
                });

                Route::group(['prefix' => 'user-type'], function () {
                    Route::get('list-user-type', [UserTypeController::class, 'list_user_types']);
                    Route::post('fetch-user-type', [UserTypeController::class, 'fetch_user_type_by_id']);
                    Route::post('search-user-type', [UserTypeController::class, 'search_user_type']);
                    Route::post('edit-user-type', [UserTypeController::class, 'edit_user_type_permissions']);
                });

                Route::group(['prefix' => 'model-has-role'], function () {
                    Route::post('create', [ModelHasRoleController::class, 'create']);
                    Route::post('delete', [ModelHasRoleController::class, 'delete']);
                    Route::get('fetch-role-member', [UserController::class, 'fetchRoleMember']);
                    Route::get('fetch-by-role-id', [ModelHasRoleController::class, 'fetchByRoleID']);
                });

                Route::group(['prefix' => 'section'], function () {
                    Route::get('fetch', [SectionController::class, 'fetch']);
                });

                Route::group(['prefix' => 'section-access'], function () {
                    Route::post('create-section-access-group', [SectionAccessController::class, 'createSectionAccessGroup']);
                    Route::get('fetch', [SectionAccessController::class, 'fetch']);
                    Route::post('create', [SectionAccessController::class, 'create']);
                    Route::get('fetch-group-by-section-id', [SectionAccessController::class, 'fetchGroupBySectionId']);
                });

                Route::group(['prefix' => 'file-access'], function () {
                    Route::post('create', [FileAccessController::class, 'create']);
                    Route::get('fetch-group-by-file-id', [FileAccessController::class, 'fetchGroupByFileId']);
                });

                Route::group(['prefix' => 'user'], function () {
                    Route::get('fetch', [UserController::class, 'fetch']);
                    Route::get('fetch-candidate-leader', [UserController::class, 'fetchCandidateLeader']);
                });

                Route::group(['prefix' => 'subrole'], function () {
                    Route::post('create', [SubRoleController::class, 'create']);
                    Route::post('delete', [SubRoleController::class, 'delete']);
                    Route::get('fetch', [SubRoleController::class, 'fetch']);
                    Route::get('fetch-module', [SubRoleModuleController::class, 'fetchModule']);
                    Route::get('is-root', [SubRoleController::class, 'isRoot']);
                });
            });

            Route::group(['prefix' => 'user-management'], function () {
                Route::group(['prefix' => 'section-access'], function () {
                    Route::get('fetch-user-by-section-id', [SectionAccessController::class, 'fetchUserBySectionId']);
                });
                Route::group(['prefix' => 'file-access'], function () {
                    Route::get('fetch-user-by-file-id', [FileAccessController::class, 'fetchUserByFileId']);
                });
                Route::group(['prefix' => 'license'], function () {
                    Route::post('create', [LicenseController::class, 'create']);
                    Route::post('delete', [LicenseController::class, 'delete']);
                    Route::get('paginate', [LicenseController::class, 'paginate']);
                    Route::post('assign-user', [LicenseController::class, 'assignUser']);
                    Route::post('assign-e-signature', [LicenseController::class, 'assignESignature']);
                    Route::post('reset', [LicenseController::class, 'reset']);
                    Route::post('resend-credential', [LicenseController::class, 'resendCredential']);
                    Route::post('rename-license', [LicenseController::class, 'renameLicense']);
                    Route::post('reset-e-signature', [LicenseController::class, 'resetESignature']);
                    Route::get('download-signature', [LicenseController::class, 'downloadSignature']);
                });
            });
        });

        Route::group(['prefix' => 'approval'], function () {
            Route::post('create', [ApprovalController::class, 'create'])->middleware(['permission:approval document private drive|approval document shared drive|approval document personal drive']);
            Route::get('is-ongoing-approval', [ApprovalController::class, 'isOngoingApproval']);
            Route::get('fetch', [UserApproverController::class, 'fetch']);
            Route::get('search', [UserApproverController::class, 'searchApproval']);
            Route::post('generate-csv', [UserApproverController::class, 'generateCSV']);
            Route::post('update-file-status', [UserApproverController::class, 'updateFileStatus']);
            Route::post('update-multiple-status-by-id', [UserApproverController::class, 'updateMultipleStatusByID']);
            Route::get('approval-history', [UserApproverController::class, 'approvalHistory']);
            Route::post('update-file-approval', [UserApproverController::class, 'updateFileApproval'])->middleware(['role:Developer|Super Admin|Admin|permission:can view file status']);
            Route::get('view-approval-message', [UserApproverController::class, 'viewApprovalMessage']);
            Route::group(['prefix' => 'template'], function () {
                Route::group(['prefix' => 'document-type'], function () {
                    Route::post('create', [DocumentTypeApprovalTemplateController::class, 'create']);
                    Route::get('fetch', [DocumentTypeApprovalTemplateController::class, 'fetch']);
                });
                Route::group(['prefix' => 'user'], function () {
                    Route::post('create', [UserApprovalTemplateController::class, 'create']);
                    Route::get('paginate', [UserApprovalTemplateController::class, 'paginate']);
                    Route::get('search', [UserApprovalTemplateController::class, 'search']);
                    Route::delete('delete', [UserApprovalTemplateController::class, 'delete']);
                });
                Route::group(['prefix' => 'admin'], function () {
                    Route::post('create', [AdminApprovalTemplateController::class, 'create']);
                    Route::patch('update-status', [AdminApprovalTemplateController::class, 'updateStatus']);
                    Route::get('paginate', [AdminApprovalTemplateController::class, 'paginate']);
                    Route::get('search', [AdminApprovalTemplateController::class, 'search']);
                    Route::post('delete', [AdminApprovalTemplateController::class, 'delete']);
                    Route::group(['prefix' => 'access'], function () {
                        Route::post('create', [UserHasAdminTemplateController::class, 'create']);
                        Route::get('paginate-by-user', [UserHasAdminTemplateController::class, 'paginateByUser']);
                        Route::get('search', [UserHasAdminTemplateController::class, 'search']);
                        Route::get('fetch-by-template', [UserHasAdminTemplateController::class, 'fetchByTemplate']);
                    });
                });
            });
        });

        Route::group(['prefix' => 'remark-type'], function () {
            Route::get('fetch', [RemarkTypeController::class, 'fetch']);
        });

        //Trash Bin
        Route::group(['prefix' => 'trashbin'], function () {
            Route::group(['prefix' => 'list'], function () {
                Route::post('folders', [TrashbinController::class, 'fetch_trash_folder']);
                Route::post('files', [TrashbinController::class, 'fetch_trash_files']);
                Route::post('versions', [TrashbinController::class, 'list_versions']);
            });
            Route::group(['prefix' => 'search'], function () {
                Route::post('files', [TrashbinController::class, 'search_trash_files']);
                Route::post('folders', [TrashbinController::class, 'search_trash_folders']);
            });
            Route::group(['prefix' => 'restore'], function () {
                Route::post('file', [TrashbinController::class, 'restore_document']);
                Route::post('folder', [TrashbinController::class, 'restore_folder']);
            });
            Route::group(['prefix' => 'delete'], function () {
                Route::post('all', [TrashbinController::class, 'empty_trash_bin']);
                Route::post('file', [TrashbinController::class, 'delete_document']);
                Route::post('folder', [TrashbinController::class, 'delete_folder']);
            });
            Route::group(['prefix' => 'view'], function () {
                Route::post('document', [TrashbinController::class, 'view_document']);
                Route::post('version', [TrashbinController::class, 'view_version']);
            });
        });

        Route::group(['prefix' => 'document-type'], function () {
            Route::get('show/{document_type}', [DocumentTypeController::class, 'show']);
            Route::post('list-all', [DocumentTypeController::class, 'list_document_types']);
            Route::get('fetch-all-document-types', [DocumentTypeController::class, 'fetch_all_document_types']);
            Route::post('create', [DocumentTypeController::class, 'create_document_type']);
            Route::post('delete', [DocumentTypeController::class, 'delete_document_type']);
            Route::post('update', [DocumentTypeController::class, 'update_document_type']);
        });

            Route::group(['prefix' => 'archive'], function() {
                Route::group(['prefix' => 'delete'] , function(){
                    Route::post('file', [ArchiveController::class, 'delete_archive_files']);
                    Route::post('folder', [FolderController::class, 'deleteFolder']);
                });
                Route::group(['prefix' => 'restore'] , function(){
                    Route::post('file', [TrashbinController::class, 'restore_document']);
                    Route::post('folder', [TrashbinController::class, 'restore_folder']);
                });
                Route::group(['prefix' => 'list'] , function(){
                    Route::post('file', [ArchiveController::class, 'listing_archive_files']);
                    Route::post('folder', [ArchiveController::class, 'listing_archive_folders']);
                });
                Route::group(['prefix' => 'search'] , function(){
                    Route::post('file', [ArchiveController::class, 'search_archive_files']);
                    Route::post('folder', [ArchiveController::class, 'search_archive_folders']);
                });
                Route::group(['prefix' => 'manual-archive'], function(){
                    Route::post('folders', [ArchiveController::class, 'manual_archive_folder']);
                });
            });

            //Notification Messages
            Route::group([ 'prefix' => 'notification_messages' ], function(){
                Route::post('create', [NMC::class, 'create_notification_messages']);
                Route::get('fetch', [NMC::class, 'fetch_notification_messages']);
            });

        Route::group(['prefix' => 'custom-form'], function () {
            Route::post('create', [CustomFormController::class, 'create']);
            Route::get('fetch-by-id', [CustomFormController::class, 'fetchByID']);
        });

        Route::group(['prefix' => 'custom-form-value'], function () {
            Route::get('fetch-user-with-license', [AuthUserController::class, 'fetchUserWithLicense']);
            Route::post('create', [CustomFormValueController::class, 'create']);
            Route::get('fetch-file-custom-description', [CustomFormValueController::class, 'fetchFileCustomDescription']);
        });

        Route::group(['prefix' => 'level-of-approver'], function () {
            Route::post('create', [LevelOfApproverController::class, 'create']);
            Route::get('paginate', [LevelOfApproverController::class, 'paginate']);
            Route::get('fetch', [LevelOfApproverController::class, 'fetch']);
            Route::delete('delete', [LevelOfApproverController::class, 'delete']);
            Route::post('restore-delete', [LevelOfApproverController::class, 'restoreDelete']);
        });

        Route::group(['prefix' => 'generated-file-link'], function () {
            Route::post('create', [GenerateFileLinkController::class, 'create'])->middleware(['permission:configure document private drive|configure document shared drive|configure document personal drive']);
            Route::get('fetch-by-file-id', [GenerateFileLinkController::class, 'fetchByFileId']);
        });

        Route::group(['prefix' => 'generate-drive-link'], function () {
            Route::post('create', [GenerateDriveLinkController::class, 'create'])->middleware(['permission:folder configure private drive|folder configure shared drive|folder configure personal drive']);
            Route::get('fetch-by-section-id', [GenerateDriveLinkController::class, 'fetchBySectionId']);
        });

        Route::group(['prefix' => 'signatory'], function () {
            Route::post('create', [FileSignatorySigneeController::class, 'create'])->middleware(['permission:assign signatory private drive|assign signatory shared drive|assign signatory personal drive']);
            Route::post('apply-signature', [FileSignatorySigneeController::class, 'applySignature']);
            Route::get('fetch-signatory', [UserController::class, 'fetchSignatory'])->middleware(['permission:list signatory private drive|list signatory shared drive|list signatory personal drive']);
            Route::get('fetch-signee-by-id', [FileSignatorySigneeController::class, 'fetchSigneeByID']);
            Route::get('fetch-by-auth-user', [FileSignatorySigneeController::class, 'fetchByAuthUser']);
            Route::get('fetch-by-file-version', [FileSignatorySigneeController::class, 'fetchByFileVersion']);
        });

        Route::group(['prefix' => 'feature'], function () {
            Route::post('create', [FeatureController::class, 'create']);
            Route::post('is-feature-enabled', [FeatureController::class, 'isFeatureEnabled']);
            Route::get('paginate', [FeatureController::class, 'paginate']);
            Route::get('fetch', [FeatureController::class, 'fetch']);
            Route::patch('update-is-enabled', [FeatureController::class, 'updateIsEnabled']);
            Route::delete('delete', [FeatureController::class, 'delete']);
        });

        Route::group(['prefix' => 'attachment'], function () {
            Route::post('create', [OtherAttachmentsController::class, 'create']);
            Route::get('fetch', [OtherAttachmentsController::class, 'fetch'])->middleware('file_access');
            Route::get('fetch-by-id', [OtherAttachmentsController::class, 'fetchById'])->middleware('file_access');
            Route::post('download', [OtherAttachmentsController::class, 'download'])->middleware('file_access');
            Route::get('file-download', [OtherAttachmentsController::class, 'fileDownload'])->middleware('file_access');
            Route::get('play-video', [OtherAttachmentsController::class, 'playVideo'])->middleware('file_access');
        });
    });
});
