<?php

namespace Suiterus\Dms\Request\Repositories;

use Illuminate\Foundation\Http\FormRequest;

class MoveFolderRequest extends FormRequest
{


    /**
     * This function returns true, which means that the user is authorized to perform the action.
     * @return bool A boolean value.
     */
    public function authorize(): bool
    {
        return true;
    }


    /**
     * The `folders` array must contain a list of objects, each of which must have an `id` property
     * that is a number and exists in the `dms_db.sections` table.
     */
    public function rules(): array
    {
        return [
            'id' => 'required|numeric|exists:dms_db.sections,id',
            'folders' => 'required|array',
            'folders.*.id' => 'required|numeric|exists:dms_db.sections,id',
        ];
    }
}
