<?php

namespace Suiterus\Dms\Request\Repositories;

use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Dms\Models\Repositories\Section;

class CreateFolderRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {

        $count = Section::where([['name', $this->input('name')], ['parent_id', $this->input('parent_id')], ['type', $this->input('type')]])->count();

        if ($count > 0) {
            $valid = [
                'name'  =>  'required|string|unique:dms_db.sections',
            ];
        } else {
            $valid = [
                'name'  =>  'required|string',
            ];
        }

        return $valid;
    }
}
