<?php

namespace Suiterus\Dms\Request\File;

use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Dms\Controllers\Configuration\AllowedFileTypesController;
use Suiterus\Dms\Models\Files\FileType;

class FileUploadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $allowedTypes = AllowedFileTypesController::getType();
        $allowedExtensions = FileType::where('status', '=', '1')->pluck('file_ext')->toArray();
        $isTiff = $this->file('files')->getClientMimeType() ==  'image/tiff' && in_array('TIFF', $allowedExtensions) ? '' : '|mimes:' . $allowedTypes;
        return [
            'files' => 'required|max:' . env('MAX_FILE_UPLOAD_SIZE') . '' . $isTiff,
        ];
    }

    public function messages(): array
    {
        return  [
            'files.required' => 'File is empty.',
            'files.mimes' => 'Invalid file type.',
        ];
    }
}
