<?php

namespace Suiterus\Dms\Request\File;

use Illuminate\Foundation\Http\FormRequest;
use Suiterus\Dms\Helper\AllowedMimeType;
use Suiterus\Dms\Models\Files\FileType;

class BatchFileUploadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $allowedExtensions = FileType::where('status', '=', '1')->pluck('file_ext')->toArray();
        $isTiff = $this->file('file')->getClientMimeType() ==  'image/tiff' && in_array('TIFF', $allowedExtensions) ? '' : '|mimesniffer';
        return [
            'file' => 'required|max:' . env('MAX_FILE_UPLOAD_SIZE') . '' . $isTiff,
        ];
    }

    public function messages(): array
    {
        return  [
            'file.mimetypes' => 'Invalid file type',
            'file.required' => 'File is empty',
        ];
    }
}
