<?php

namespace Suiterus\Dms\Models\Signatory;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Signatory\FileSignatory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FileSignatorySignee extends Model
{
    use HasFactory;

    protected $fillable = [
        'file_signatory_id',
        'user_id',
        'option',
        'sequence',
        'status',
    ];

    protected $with = [
        'user'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.file_signatory_signees';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->select('id', 'name')->without(['permissions', 'roles', 'employeeMetaInfo', 'exitInterview', 'supervisor', 'storage']);
    }

    public function fileSignatory(){
        return $this->belongsTo(FileSignatory::class, 'file_signatory_id', 'id');
    }
}
