<?php

namespace Suiterus\Dms\Models\Signatory;

use App\Traits\Encryptable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FileSignatorySignature extends Model
{
    use HasFactory, Encryptable;

    protected $fillable = [
        'file_signatory_id',
        'document_encrypted_path',
        'document_signature_path',
    ];

    protected $encryptable = [
        'document_encrypted_path',
        'document_signature_path',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.file_signatory_signatures';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }


}
