<?php

namespace Suiterus\Dms\Models\Signatory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Files\FileVersion;

class FileSignatory extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'file_version_id',
        'is_any_order',
        'status'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.file_signatories';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function fileVersion(){
        return $this->belongsTo(FileVersion::class, 'file_version_id', 'id')->withTrashed();
    }

    public function signee()
    {
        return $this->hasMany(FileSignatorySignee::class, 'file_signatory_id', 'id');
    }

    public function fileSignatorySignature()
    {
        return $this->hasOne(FileSignatorySignature::class, 'file_signatory_id', 'id');
    }
}
