<?php

namespace Suiterus\Dms\Models\Repositories;

use App\Models\AccessManagement\GroupManagement\Role;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Repositories\Section;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SectionAccess extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'section_id',
        'group_id',
        'access_level',
        'shared_by',
        'shared_date',
    ];

    protected $with = [
        'section',
        'user',
        'group'
    ];

    protected $casts = [
        'shared_date' => 'date:M d, Y'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.section_accesses';
        parent::__construct($attributes);
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id', 'id')->without(['access', 'files']);
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function sharedBy()
    {
        return $this->belongsTo('App\Models\User', 'shared_by', 'id');
    }

    public function group()
    {
        return $this->belongsTo(Role::class, 'group_id', 'id')->with([
            'roleHasSystem' => function ($query) {
                $query->without(['role']);
            }
        ])->without([
            'roleLeader',
            'sectionAccess',
            'member'
        ]);
    }
}
