<?php

namespace Suiterus\Dms\Models\Repositories;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;

class Section extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'dms_db';

    protected $fillable = [
        'name',
        'description',
        'type',
        'parent_id',
        'status',
        'created_by',
        'deleted_by'
    ];

    protected $with = [
        'author',
        'access'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.sections';
        parent::__construct($attributes);
    }

    public function sharedBy()
    {
        $authUserRoles = Auth::user()->roles->pluck('id');
        return $this->hasOne(SectionAccess::class, 'section_id', 'id')->where('user_id', Auth::id())->orWhereIn('group_id', $authUserRoles);
    }

    public function parent()
    {
        return $this->hasOne('Suiterus\Dms\Models\Repositories\Section', 'id', 'parent_id');
    }


    public function children()
    {
        return $this->hasMany('Suiterus\Dms\Models\Repositories\Section', 'parent_id', 'id')->with('children');
    }

    public function access()
    {
        return $this->hasMany(SectionAccess::class, 'section_id', 'id');
    }

    public function files()
    {
        return $this->hasMany('Suiterus\Dms\Models\Files\File');
    }


    public function author()
    {
        return $this->belongsTo('App\Models\User', 'created_by', 'id')->select('id', 'name')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
        ]);
    }


    public function deletedBy()
    {
        return $this->belongsTo('App\Models\User', 'deleted_by', 'id')->select('id', 'name')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
        ]);
    }
}
