<?php

namespace Suiterus\Dms\Models\OtherAttachments;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Files;
use Suiterus\Dms\Models\Files\File;

class OtherAttachments extends Model
{
    use HasFactory;

    protected $fillable = [
        'file_id',
        'user_id',
        'name',
        'path',
        'updated_by'
    ];

    protected $with = [
        'uploadedBy'
    ];

    protected $hidden = [
        'path',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.file_other_attachments';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function file()
    {
        return $this->belongsTo(File::class, 'file_id', 'id')->without([
            'author',
            'modifier',
            'extraFields',
            'access',
            'versions',
            'documentType'
        ]);
    }

    public function uploadedBy()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'profileBasicInfo'
        ]);
    }
}
