<?php

namespace Suiterus\Dms\Models\GenerateLink;

use Suiterus\Dms\Models\Files\File;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Files\FileVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class GenerateFileLink extends Model
{
    use HasFactory;
    protected $fillable = [
        'file_id',
        'generated_file_link',
        'is_viewable',
        'created_by',
    ];

    protected $with = [
        'file'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.generate_file_links';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function file()
    {
        return $this->belongsTo(File::class, 'file_id', 'id')->without([
            'modifier',
            'extraFields',
            'access',
            'versions',
            'documentType'
        ])->with(['latestVersion']);
    }
}
