<?php

namespace Suiterus\Dms\Models\GenerateLink;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Repositories\Section;

class GenerateDriveLink extends Model
{
    use HasFactory;
    protected $fillable = [
        'section_id',
        'generated_drive_link',
        'is_viewable',
        'created_by',
    ];

    protected $with = [
        'section'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.generate_drive_links';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id', 'id');
    }
}
