<?php

namespace Suiterus\Dms\Models\Files;

use App\Models\AccessManagement\GroupManagement\Role as GroupManagementRole;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Permission\Models\Role;

class Forward extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'dms_db';

    protected $fillable = [
        'file_id',
        'user_id',
        'role_id',
        'access_level',
        'subject',
        'message',
        'created_by',
        'status'
    ];

    protected $with = [
        'user',
        'sender',
        'file',
        'group'
    ];

    public function file()
    {
        return $this->belongsTo('Suiterus\Dms\Models\Files\File', 'file_id', 'id')->without([
            'author',
            'modifier',
            'extraFields',
            'access',
            'versions',
            'documentType'
        ]);
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function sender()
    {
        return $this->belongsTo('App\Models\User', 'created_by', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function group()
    {
        return $this->belongsTo(GroupManagementRole::class, 'role_id', 'id');
    }
}
