<?php

namespace Suiterus\Dms\Models\Files;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Dms\Models\CustomForm\CustomFormValue;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Dms\Models\Files\FileComment;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Approvals\Approval;

class FileVersion extends Model
{
    use HasFactory,
        SoftDeletes;

    protected $connection = 'dms_db';

    protected $fillable = [
        'file_id',
        'file_name',
        'file_version',
        'created_by',
        'path'
    ];

    protected $with = [
        'user',
        'comment',
        'forward',
        'customFormValue'
    ];

    public function approval()
    {
        return $this->hasOne(Approval::class, 'file_version_id', 'id')->latest();
    }

    public function file()
    {
        return $this->belongsTo('Suiterus\Dms\Models\Files\File', 'file_id', 'id')->withTrashed()->without([
            'extraFields',
            'access',
            'versions',
        ]);
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'created_by', 'id');
    }

    public function comment()
    {
        return $this->hasMany(FileComment::class, 'file_version_id', 'id')->orderBy('created_at', 'desc');
    }

    public function forward()
    {
        return $this->hasMany(Forward::class, 'file_id', 'id');
    }

    public function customFormValue()
    {
        return $this->hasOne(CustomFormValue::class, 'file_version_id', 'id');
    }

    public function fileSignatory()
    {
        return $this->hasMany('Suiterus\Dms\Models\Signatory\FileSignatory', 'file_version_id', 'id');
    }
}
