<?php

namespace Suiterus\Dms\Models\Files;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class FileType extends Model
{
    use HasFactory, SoftDeletes;
    protected $connection = 'dms_db';

    protected $fillable = [
        'file_ext',
        'mime_type',
        'unit_byte',
        'value',
        'status'
    ];

    protected $casts = [
        'mime_type' => 'json'
    ];
}
